/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.List;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.InstallsAwareAction;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LifecycleAction
extends InstallsAwareAction {
    protected abstract LifecycleMetaData getInstallLifecycle(BeanMetaData var1);

    protected abstract LifecycleMetaData getUninstallLifecycle(BeanMetaData var1);

    protected String getMethod(LifecycleMetaData lifecycle) {
        if (lifecycle != null) {
            return lifecycle.getMethodName();
        }
        return null;
    }

    protected List<ParameterMetaData> getParameters(LifecycleMetaData lifecycle) {
        if (lifecycle != null) {
            return lifecycle.getParameters();
        }
        return null;
    }

    protected String getInstallMethod(BeanMetaData beanMetaData) {
        return this.getMethod(this.getInstallLifecycle(beanMetaData));
    }

    public abstract String getDefaultInstallMethod();

    protected List<ParameterMetaData> getInstallParameters(BeanMetaData beanMetaData) {
        return this.getParameters(this.getInstallLifecycle(beanMetaData));
    }

    protected String getUninstallMethod(BeanMetaData beanMetaData) {
        return this.getMethod(this.getUninstallLifecycle(beanMetaData));
    }

    public abstract String getDefaultUninstallMethod();

    protected List<ParameterMetaData> getUninstallParameters(BeanMetaData beanMetaData) {
        return this.getParameters(this.getUninstallLifecycle(beanMetaData));
    }

    protected boolean isInstallInvocationIgnored(KernelControllerContext context) {
        return this.isInvocationIgnored(this.getInstallLifecycle(context.getBeanMetaData()));
    }

    protected boolean isUninstallInvocationIgnored(KernelControllerContext context) {
        return this.isInvocationIgnored(this.getUninstallLifecycle(context.getBeanMetaData()));
    }

    protected boolean isInvocationIgnored(LifecycleMetaData lifecycle) {
        return lifecycle != null && lifecycle.isIgnored();
    }

    @Override
    protected void installActionInternal(KernelControllerContext context) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (!this.isInstallInvocationIgnored(context)) {
            MethodJoinpoint joinpoint;
            KernelController controller = (KernelController)context.getController();
            Kernel kernel = controller.getKernel();
            KernelConfigurator configurator = kernel.getConfigurator();
            Object target = context.getTarget();
            BeanInfo info = context.getBeanInfo();
            BeanMetaData metaData = context.getBeanMetaData();
            String method = this.getInstallMethod(context);
            List<ParameterMetaData> parameters = this.getInstallParameters(context);
            try {
                ClassLoader cl = Configurator.getClassLoader(metaData);
                joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
            }
            catch (JoinpointException ignored) {
                if (trace) {
                    if (parameters == null) {
                        this.log.trace((Object)("No " + method + " method for " + context));
                    } else {
                        this.log.trace((Object)("No " + method + parameters + " method for " + context));
                    }
                }
                return;
            }
            joinpoint.setTarget(target);
            LifecycleAction.dispatchJoinPoint(context, (Joinpoint)joinpoint);
        } else if (trace) {
            this.log.trace((Object)("Ignoring " + this.getDefaultInstallMethod() + " lifecycle invocation."));
        }
    }

    @Override
    protected void uninstallActionInternal(KernelControllerContext context) {
        block7: {
            boolean trace = this.log.isTraceEnabled();
            if (!this.isUninstallInvocationIgnored(context)) {
                KernelController controller = (KernelController)context.getController();
                Kernel kernel = controller.getKernel();
                KernelConfigurator configurator = kernel.getConfigurator();
                Object target = context.getTarget();
                BeanInfo info = context.getBeanInfo();
                BeanMetaData metaData = context.getBeanMetaData();
                String method = this.getUninstallMethod(context);
                List<ParameterMetaData> parameters = this.getUninstallParameters(context);
                try {
                    ClassLoader cl = Configurator.getClassLoader(metaData);
                    MethodJoinpoint joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
                    joinpoint.setTarget(target);
                    LifecycleAction.dispatchJoinPoint(context, (Joinpoint)joinpoint);
                }
                catch (JoinpointException ignored) {
                    if (!trace) break block7;
                    if (parameters == null) {
                        this.log.trace((Object)("No " + method + " method for " + context));
                        break block7;
                    }
                    this.log.trace((Object)("No " + method + parameters + " method for " + context));
                }
                catch (Throwable throwable) {
                    this.log.warn((Object)("Error during " + method + " for " + context.getName()), throwable);
                }
            } else if (trace) {
                this.log.trace((Object)("Ignoring " + this.getDefaultUninstallMethod() + " lifecycle invocation."));
            }
        }
    }

    public String getInstallMethod(KernelControllerContext context) {
        String installMethod = this.getInstallMethod(context.getBeanMetaData());
        if (installMethod != null) {
            return installMethod;
        }
        return this.getDefaultInstallMethod();
    }

    public List<ParameterMetaData> getInstallParameters(KernelControllerContext context) {
        return this.getInstallParameters(context.getBeanMetaData());
    }

    public String getUninstallMethod(KernelControllerContext context) {
        String uninstallMethod = this.getUninstallMethod(context.getBeanMetaData());
        if (uninstallMethod != null) {
            return uninstallMethod;
        }
        return this.getDefaultUninstallMethod();
    }

    public List<ParameterMetaData> getUninstallParameters(KernelControllerContext context) {
        return this.getUninstallParameters(context.getBeanMetaData());
    }
}

