/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreAPI;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.TxLog;
import com.arjuna.common.internal.util.ClassloadingUtility;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;

public class StoreManager {
    private static ObjectStoreAPI actionStore = null;
    private static ObjectStoreAPI stateStore = null;
    private static ObjectStoreAPI communicationStore = null;

    public StoreManager(ObjectStoreAPI actionStore, ObjectStoreAPI stateStore, ObjectStoreAPI communicationStore) {
        if (StoreManager.actionStore != null || StoreManager.stateStore != null || StoreManager.communicationStore != null) {
            throw new IllegalStateException("store already initialized!");
        }
        StoreManager.actionStore = actionStore;
        StoreManager.stateStore = stateStore;
        StoreManager.communicationStore = communicationStore;
    }

    public static final void shutdown() {
        if (actionStore != null) {
            actionStore.stop();
        }
        if (stateStore != null) {
            stateStore.stop();
        }
        if (communicationStore != null) {
            communicationStore.stop();
        }
        actionStore = null;
        stateStore = null;
        communicationStore = null;
    }

    public static final RecoveryStore getRecoveryStore() {
        return StoreManager.getActionStore();
    }

    public static final TxLog getTxLog() {
        return StoreManager.getActionStore();
    }

    public static final ParticipantStore getParticipantStore() {
        return StoreManager.getActionStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ParticipantStore getCommunicationStore() {
        if (communicationStore != null) {
            return communicationStore;
        }
        Class<StoreManager> clazz = StoreManager.class;
        synchronized (StoreManager.class) {
            if (communicationStore != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return communicationStore;
            }
            communicationStore = StoreManager.initStore("communicationStore");
            // ** MonitorExit[var0] (shouldn't be in output)
            return communicationStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ObjectStoreAPI getActionStore() {
        if (actionStore != null) {
            return actionStore;
        }
        Class<StoreManager> clazz = StoreManager.class;
        synchronized (StoreManager.class) {
            if (actionStore != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return actionStore;
            }
            actionStore = StoreManager.initStore(null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return actionStore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParticipantStore setupStore(String rootName, int sharedStatus) {
        if (stateStore != null) {
            return stateStore;
        }
        Class<StoreManager> clazz = StoreManager.class;
        synchronized (StoreManager.class) {
            if (stateStore != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return stateStore;
            }
            stateStore = StoreManager.initStore("stateStore");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return stateStore;
        }
    }

    private static final ObjectStoreAPI initStore(String name) {
        ObjectStoreAPI store;
        ObjectStoreEnvironmentBean storeEnvBean = (ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)name);
        String storeType = storeEnvBean.getObjectStoreType();
        try {
            store = (ObjectStoreAPI)ClassloadingUtility.loadAndInstantiateClass(ObjectStoreAPI.class, (String)storeType, (String)name);
        }
        catch (Throwable ex) {
            throw new FatalError(tsLogger.i18NLogger.get_StoreManager_invalidtype() + " " + storeType, ex);
        }
        store.start();
        return store;
    }

    public static ObjectStoreAPI getTxOJStore() {
        return (ObjectStoreAPI)StoreManager.setupStore(null, 14);
    }

    public static ObjectStoreAPI getEISNameStore() {
        return (ObjectStoreAPI)StoreManager.setupStore(null, 14);
    }
}

