/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.txoj;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.ActionHierarchy;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.txoj.LockConflictManager;
import com.arjuna.ats.internal.txoj.LockList;
import com.arjuna.ats.internal.txoj.LockListIterator;
import com.arjuna.ats.internal.txoj.abstractrecords.CadaverLockRecord;
import com.arjuna.ats.internal.txoj.abstractrecords.LockRecord;
import com.arjuna.ats.internal.txoj.lockstore.BasicLockStore;
import com.arjuna.ats.internal.txoj.lockstore.BasicPersistentLockStore;
import com.arjuna.ats.txoj.Lock;
import com.arjuna.ats.txoj.common.txojPropertyManager;
import com.arjuna.ats.txoj.exceptions.LockStoreException;
import com.arjuna.ats.txoj.lockstore.LockStore;
import com.arjuna.ats.txoj.logging.txojLogger;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.locks.ReentrantLock;

public class LockManager
extends StateManager {
    public static final int defaultRetry = 100;
    public static final int defaultSleepTime = 250;
    public static final int waitTotalTimeout = -100;
    protected String lockStoreType = txojPropertyManager.getTxojEnvironmentBean().getLockStoreType();
    protected String systemKey;
    protected LockList locksHeld;
    protected final Object locksHeldLockObject = new Object();
    protected LockStore lockStore;
    protected boolean stateLoaded;
    protected boolean hasBeenLocked;
    protected boolean objectLocked;
    protected ReentrantLock mutex = new ReentrantLock();
    protected LockConflictManager conflictManager;
    protected static final int DOZE_TIME = 1000000;
    protected static final boolean nestedLocking = txojPropertyManager.getTxojEnvironmentBean().isAllowNestedLocking();

    public void finalize() throws Throwable {
        BasicAction action;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LockManager.finalize() for object-id " + this.get_uid() + " type " + this.type()));
        }
        if (this.status() == 3 && (action = BasicAction.Current()) != null && action.status() == 0) {
            tsLogger.i18NLogger.warn_StateManager_1();
            this.cleanup(false);
        }
        boolean doSignal = false;
        this.cleanUp();
        if (this.mutex != null && this.mutex.isLocked()) {
            doSignal = true;
        }
        this.locksHeld = null;
        this.lockStore = null;
        this.conflictManager = null;
        try {
            if (doSignal) {
                this.mutex.unlock();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mutex = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean propagate(Uid from, Uid to) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::propagate(" + from + ", " + to + ")"));
        }
        boolean result = false;
        int retryCount = 10;
        if (this.lockMutex()) {
            Object object;
            do {
                try {
                    object = this.locksHeldLockObject;
                    synchronized (object) {
                        if (this.loadState()) {
                            LockList oldlist = this.locksHeld;
                            Lock current = null;
                            this.locksHeld = new LockList();
                            if (this.locksHeld != null) {
                                while ((current = oldlist.pop()) != null) {
                                    if (current.getCurrentOwner().equals(from)) {
                                        current.propagate();
                                    }
                                    if (this.locksHeld.insert(current)) continue;
                                    current = null;
                                }
                                oldlist = null;
                                result = true;
                            } else {
                                this.freeState();
                                throw new NullPointerException();
                            }
                        }
                        if (result) {
                            result = this.unloadState();
                        }
                    }
                }
                catch (NullPointerException e) {
                    result = false;
                }
                if (result) continue;
                if (tsLogger.logger.isTraceEnabled()) {
                    tsLogger.logger.trace((Object)"LockManager.propagate() Dozing");
                }
                this.conflictManager.wait(1, 1000000);
            } while (!result && --retryCount > 0);
            if (!result) {
                txojLogger.i18NLogger.warn_LockManager_1();
                object = this.locksHeldLockObject;
                synchronized (object) {
                    this.freeState();
                }
            }
            this.unlockMutex();
        }
        return result;
    }

    public final boolean releaseAll(Uid actionUid) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::releaseAll(" + actionUid + ")"));
        }
        return this.doRelease(actionUid, true);
    }

    public final boolean releaselock(Uid lockUid) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::releaseLock(" + lockUid + ")"));
        }
        return this.doRelease(lockUid, false);
    }

    public final int setlock(Lock toSet) {
        return this.setlock(toSet, 100, 250);
    }

    public final int setlock(Lock toSet, int retry) {
        return this.setlock(toSet, retry, 250);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setlock(Lock toSet, int retry, int sleepTime) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::setlock(" + (Object)((Object)toSet) + ", " + retry + ", " + sleepTime + ")"));
        }
        int returnStatus = 1;
        Object toLock = BasicAction.Current();
        if (toLock == null) {
            toLock = new Object();
        }
        BasicAction basicAction = toLock;
        synchronized (basicAction) {
            if (!this.lockMutex()) {
                return 1;
            }
            try {
                int conflict = 0;
                LockRecord newLockR = null;
                boolean modifyRequired = false;
                BasicAction currAct = null;
                if (toSet == null) {
                    txojLogger.i18NLogger.warn_LockManager_2();
                    int n = 1;
                    return n;
                }
                currAct = BasicAction.Current();
                if (currAct != null) {
                    ActionHierarchy ah = currAct.getHierarchy();
                    if (ah != null) {
                        toSet.changeHierarchy(ah);
                    } else {
                        txojLogger.i18NLogger.warn_LockManager_3();
                        toSet = null;
                        int n = 1;
                        return n;
                    }
                }
                if (super.loadObjectState()) {
                    super.setupStore();
                }
                while (conflict == 0) {
                    if (retry < 0) {
                        if (retry != -100) return returnStatus;
                        if (sleepTime <= 0) return returnStatus;
                    }
                    Object object = this.locksHeldLockObject;
                    synchronized (object) {
                        block35: {
                            block36: {
                                conflict = 0;
                                if (this.loadState()) {
                                    conflict = this.lockConflict(toSet);
                                } else {
                                    txojLogger.i18NLogger.warn_LockManager_4();
                                }
                                if (conflict == 0) break block35;
                                modifyRequired = toSet.modifiesObject();
                                if (!super.activate()) break block36;
                                returnStatus = 0;
                                if (conflict == 1) {
                                    int lrStatus = 2;
                                    if (currAct != null && (lrStatus = currAct.add((AbstractRecord)(newLockR = new LockRecord(this, !modifyRequired, currAct)))) != 2) {
                                        newLockR = null;
                                        if (lrStatus == 3) {
                                            returnStatus = 1;
                                        }
                                    }
                                    if (returnStatus == 0) {
                                        this.locksHeld.insert(toSet);
                                    }
                                }
                                break block35;
                            }
                            txojLogger.i18NLogger.warn_LockManager_5();
                            returnStatus = 1;
                        }
                        if (returnStatus == 0 && conflict == 1) {
                            if (!this.unloadState()) {
                                txojLogger.i18NLogger.warn_LockManager_6();
                                returnStatus = 1;
                            }
                        } else {
                            this.freeState();
                        }
                        if (returnStatus == 0 && modifyRequired) {
                            if (super.modified()) {
                                this.hasBeenLocked = true;
                            } else {
                                conflict = 0;
                                returnStatus = 1;
                            }
                        }
                        if (conflict == 0) {
                            this.freeState();
                        }
                        if (conflict != 0) continue;
                    }
                    if (retry != 0) {
                        if (sleepTime > 0) {
                            sleepTime -= this.conflictManager.wait(retry, sleepTime);
                        } else {
                            retry = 0;
                        }
                    }
                    if (retry == -100) continue;
                    --retry;
                }
                return returnStatus;
            }
            finally {
                this.unlockMutex();
            }
        }
    }

    public void print(PrintWriter strm) {
        LockListIterator next = new LockListIterator(this.locksHeld);
        strm.println("LocalLockManager for object " + this.get_uid());
        if (!this.stateLoaded) {
            strm.println("No loaded state");
        } else if (this.locksHeld != null) {
            Lock current;
            strm.println("\tCurrently holding : " + this.locksHeld.entryCount() + " locks");
            while ((current = next.iterate()) != null) {
                current.print(strm);
            }
        } else {
            strm.println("Currently holding : 0 locks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printState(PrintWriter strm) {
        Object object = this.locksHeldLockObject;
        synchronized (object) {
            boolean iDeleteState = false;
            if (!this.stateLoaded) {
                this.loadState();
                iDeleteState = true;
            }
            this.print(strm);
            if (iDeleteState) {
                this.freeState();
            }
        }
    }

    public String type() {
        return "StateManager/LockManager";
    }

    protected LockManager(Uid storeUid) {
        this(storeUid, 1, 0);
    }

    protected LockManager(Uid storeUid, int ot) {
        this(storeUid, ot, 0);
    }

    protected LockManager(Uid storeUid, int ot, int om) {
        super(storeUid, ot, om);
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::LockManager(" + storeUid + ")"));
        }
        this.systemKey = null;
        this.locksHeld = new LockList();
        this.lockStore = null;
        this.stateLoaded = false;
        this.hasBeenLocked = false;
        this.objectLocked = false;
        this.conflictManager = new LockConflictManager(this.mutex);
    }

    protected LockManager() {
        this(0);
    }

    protected LockManager(int ot) {
        this(ot, 0);
    }

    protected LockManager(int ot, int om) {
        super(ot, om);
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::LockManager(" + ot + ")"));
        }
        this.systemKey = null;
        this.locksHeld = new LockList();
        this.lockStore = null;
        this.stateLoaded = false;
        this.hasBeenLocked = false;
        this.objectLocked = false;
        this.conflictManager = new LockConflictManager(this.mutex);
    }

    protected void terminate() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::terminate() for object-id " + this.get_uid()));
        }
        this.cleanUp();
        super.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void cleanUp() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::cleanUp() for object-id " + this.get_uid()));
        }
        if (this.lockMutex()) {
            if (this.hasBeenLocked) {
                if (this.objectModel == 1 && this.systemKey == null) {
                    this.initialise();
                }
                BasicAction current = BasicAction.Current();
                Hashtable hashtable = this.usingActions;
                synchronized (hashtable) {
                    if (this.usingActions != null) {
                        Enumeration e = this.usingActions.elements();
                        while (e.hasMoreElements()) {
                            CadaverLockRecord A;
                            BasicAction action = (BasicAction)e.nextElement();
                            if (action == null || action.add((AbstractRecord)(A = new CadaverLockRecord(this.lockStore, this, action))) == 2) continue;
                            A = null;
                        }
                    }
                }
                this.hasBeenLocked = false;
            }
            this.unlockMutex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRelease(Uid u, boolean all) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::doRelease(" + u + ", " + all + ")"));
        }
        if (!this.lockMutex()) {
            return false;
        }
        Lock previous = null;
        Lock current = null;
        boolean deleted = false;
        boolean result = false;
        int retryCount = 10;
        boolean loaded = false;
        boolean releasedOK = false;
        BasicAction currAct = BasicAction.Current();
        try {
            Object object = this.locksHeldLockObject;
            synchronized (object) {
                do {
                    if (this.loadState()) {
                        loaded = true;
                        LockListIterator next = new LockListIterator(this.locksHeld);
                        previous = null;
                        while ((current = next.iterate()) != null) {
                            Uid checkUid = null;
                            checkUid = all ? current.getCurrentOwner() : current.get_uid();
                            if (u.equals(checkUid)) {
                                this.locksHeld.forgetNext(previous);
                                current = null;
                                deleted = true;
                                if (all) continue;
                                break;
                            }
                            previous = current;
                        }
                        result = true;
                    } else {
                        this.freeState();
                        result = false;
                    }
                    if (!result) {
                        try {
                            if (tsLogger.logger.isTraceEnabled()) {
                                tsLogger.logger.trace((Object)"LockManager.doRelease() Dozing");
                            }
                            Thread.sleep(1000000L);
                        }
                        catch (InterruptedException next) {}
                        continue;
                    }
                    if (!loaded) {
                        txojLogger.i18NLogger.warn_LockManager_7();
                        continue;
                    }
                    if (!deleted && txojLogger.logger.isTraceEnabled()) {
                        txojLogger.logger.trace((Object)" *** CANNOT locate locks  ***");
                    }
                    int unloadRetryCount = 10;
                    do {
                        if (!this.unloadState()) {
                            txojLogger.i18NLogger.warn_LockManager_8();
                            continue;
                        }
                        releasedOK = true;
                    } while (--unloadRetryCount > 0 && !releasedOK);
                } while (!result && --retryCount > 0);
            }
            this.conflictManager.signal();
        }
        finally {
            this.unlockMutex();
        }
        return releasedOK;
    }

    protected final void freeState() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)"LockManager::freeState()");
        }
        if (this.mutex != null) {
            if (this.objectModel != 0) {
                while (this.locksHeld.pop() != null) {
                }
                this.stateLoaded = false;
                if (this.objectLocked) {
                    this.objectLocked = false;
                    this.mutex.unlock();
                }
            } else {
                this.stateLoaded = false;
            }
        } else {
            this.stateLoaded = false;
            this.objectLocked = false;
        }
    }

    protected final boolean initialise() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)"LockManager::initialise()");
        }
        boolean result = false;
        if (this.systemKey == null) {
            this.systemKey = this.type();
            if (this.mutex != null) {
                this.mutex.lock();
                if (this.lockStore == null) {
                    try {
                        if (txojLogger.logger.isTraceEnabled()) {
                            txojLogger.logger.trace((Object)("LockManager::initialise() lockStoreType is " + this.lockStoreType));
                        }
                        if (this.lockStoreType.equals(BasicLockStore.class.getName())) {
                            this.lockStore = new BasicLockStore();
                        } else {
                            ObjectStoreEnvironmentBean objectStoreEnvironmentBean = (ObjectStoreEnvironmentBean)BeanPopulator.getDefaultInstance(ObjectStoreEnvironmentBean.class);
                            objectStoreEnvironmentBean.setLocalOSRoot(this.systemKey);
                            this.lockStore = new BasicPersistentLockStore(objectStoreEnvironmentBean);
                        }
                    }
                    catch (Exception ex) {
                        txojLogger.i18NLogger.warn_LockManager_14(ex);
                    }
                }
                this.mutex.unlock();
            }
        }
        result = this.lockStore != null;
        return result;
    }

    protected final boolean isAncestorOf(Lock heldLock) {
        BasicAction action;
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::isAncestorOf(" + heldLock.getCurrentOwner() + ")"));
        }
        if ((action = BasicAction.Current()) == null) {
            return false;
        }
        return action.isAncestor(heldLock.getCurrentOwner());
    }

    protected boolean loadState() {
        block20: {
            if (txojLogger.logger.isTraceEnabled()) {
                txojLogger.logger.trace((Object)"LockManager::loadState()");
            }
            if (this.objectModel == 0) {
                this.stateLoaded = true;
                return true;
            }
            InputObjectState S = null;
            if (this.systemKey == null && !this.initialise()) {
                return false;
            }
            if (this.mutex == null || !this.mutex.tryLock()) {
                return false;
            }
            this.stateLoaded = false;
            this.objectLocked = true;
            try {
                S = this.lockStore.read_state(this.get_uid(), this.type());
                if (S != null) {
                    Uid u = null;
                    Lock current = null;
                    int count = 0;
                    try {
                        count = S.unpackInt();
                        boolean cleanLoad = true;
                        if (txojLogger.logger.isTraceEnabled()) {
                            txojLogger.logger.trace((Object)("LockManager::loadState() loading " + count + " lock(s)"));
                        }
                        for (int i = 0; i < count && cleanLoad; ++i) {
                            try {
                                u = UidHelper.unpackFrom((InputBuffer)S);
                                current = new Lock(u);
                                if (current != null) {
                                    if (current.restore_state(S, 1)) {
                                        this.locksHeld.push(current);
                                        continue;
                                    }
                                    current = null;
                                    cleanLoad = false;
                                    continue;
                                }
                                cleanLoad = false;
                                continue;
                            }
                            catch (IOException e) {
                                cleanLoad = false;
                            }
                        }
                        if (cleanLoad) {
                            this.stateLoaded = true;
                        } else {
                            while ((current = this.locksHeld.pop()) != null) {
                                current = null;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    S = null;
                    break block20;
                }
                this.stateLoaded = true;
            }
            catch (LockStoreException e) {
                txojLogger.logger.warn((Object)e);
            }
        }
        if (!this.stateLoaded) {
            if (this.mutex != null) {
                this.mutex.unlock();
            }
            this.objectLocked = false;
        }
        return this.stateLoaded;
    }

    protected final int lockConflict(Lock otherLock) {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::lockConflict(" + otherLock.get_uid() + ")"));
        }
        boolean matching = false;
        Lock heldLock = null;
        LockListIterator next = new LockListIterator(this.locksHeld);
        while ((heldLock = next.iterate()) != null) {
            if (heldLock.conflictsWith(otherLock)) {
                if (nestedLocking) {
                    if (this.isAncestorOf(heldLock)) continue;
                    return 0;
                }
                return 0;
            }
            if (!heldLock.equals(otherLock)) continue;
            matching = true;
        }
        return matching ? 2 : 1;
    }

    protected final boolean unloadState() {
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)"LockManager::unloadState()");
        }
        if (this.objectModel == 0) {
            this.stateLoaded = false;
            return true;
        }
        boolean unloadOk = false;
        Lock current = null;
        String otype = this.type();
        Uid u = this.get_uid();
        OutputObjectState S = new OutputObjectState(u, otype);
        int lockCount = this.locksHeld.entryCount();
        if (txojLogger.logger.isTraceEnabled()) {
            txojLogger.logger.trace((Object)("LockManager::unloadState() unloading " + lockCount + " lock(s)"));
        }
        if (lockCount == 0) {
            if (this.lockStore.remove_state(u, otype)) {
                unloadOk = true;
            } else {
                txojLogger.i18NLogger.warn_LockManager_10(u, otype);
            }
        } else {
            try {
                S.packInt(lockCount);
                unloadOk = true;
                while ((current = this.locksHeld.pop()) != null) {
                    UidHelper.packInto((Uid)current.get_uid(), (OutputBuffer)S);
                    if (!current.save_state(S, 1)) {
                        txojLogger.i18NLogger.warn_LockManager_11(current.toString());
                        unloadOk = false;
                    }
                    current = null;
                }
                if (unloadOk) {
                    unloadOk = false;
                    if (S.valid() && this.lockStore.write_committed(u, otype, S)) {
                        unloadOk = true;
                    } else {
                        txojLogger.i18NLogger.warn_LockManager_12(u, otype);
                    }
                }
            }
            catch (IOException e) {
                unloadOk = false;
                txojLogger.i18NLogger.warn_LockManager_13(u, otype);
            }
        }
        this.stateLoaded = false;
        if (this.objectLocked) {
            this.objectLocked = false;
            if (this.mutex != null) {
                this.mutex.unlock();
            }
        }
        return unloadOk;
    }
}

