/*
 * Copyright 2009 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package org.jboss.netty.channel.socket.http;

import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.SocketChannel;

/**
 * Creates a client-side {@link SocketChannel} which connects to an
 * {@link HttpTunnelingServlet} to communicate with the server application
 * behind the {@link HttpTunnelingServlet}.  Please refer to the
 * <a href="package-summary.html#package_description">package summary</a> for
 * the detailed usage.
 *
 * @author The Netty Project (netty-dev@lists.jboss.org)
 * @author Andy Taylor (andy.taylor@jboss.org)
 * @author Trustin Lee (tlee@redhat.com)
 * @version $Rev: 1685 $, $Date: 2009-08-28 16:15:49 +0900 (금, 28 8 2009) $
 *
 * @apiviz.landmark
 */
public class HttpTunnelingClientSocketChannelFactory implements ClientSocketChannelFactory {

    private final ChannelSink sink = new HttpTunnelingClientSocketPipelineSink();
    private final ClientSocketChannelFactory clientSocketChannelFactory;

    /**
     * Creates a new instance.
     */
    public HttpTunnelingClientSocketChannelFactory(ClientSocketChannelFactory clientSocketChannelFactory) {
        this.clientSocketChannelFactory = clientSocketChannelFactory;
    }

    public SocketChannel newChannel(ChannelPipeline pipeline) {
        return new HttpTunnelingClientSocketChannel(this, pipeline, sink, clientSocketChannelFactory);
    }

    public void releaseExternalResources() {
        clientSocketChannelFactory.releaseExternalResources();
    }
}
