/*
 * Copyright 2009 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package org.jboss.netty.handler.codec.embedder;

/**
 * A helper that wraps an encoder or a decoder (codec) so that they can be used
 * without doing actual I/O in unit tests or higher level codecs.  Please refer
 * to {@link EncoderEmbedder} and {@link DecoderEmbedder} for more information.
 *
 * @author The Netty Project (netty-dev@lists.jboss.org)
 * @author Trustin Lee (tlee@redhat.com)
 * @version $Rev: 1685 $, $Date: 2009-08-28 16:15:49 +0900 (금, 28 8 2009) $
 */
public interface CodecEmbedder<T> {
    /**
     * Offers an input object to the pipeline of this embedder.
     *
     * @return {@code true} if and only if there is something to read in the
     *         product queue (see {@link #poll()} and {@link #peek()})
     */
    boolean offer(Object input);

    /**
     * Signals the pipeline that the encoding or decoding has been finished and
     * no more data will be offered.
     *
     * @return {@code true} if and only if there is something to read in the
     *         product queue (see {@link #poll()} and {@link #peek()})
     */
    boolean finish();

    /**
     * Consumes an encoded or decoded output from the product queue. The output
     * object is generated by the offered input objects.
     *
     * @return an encoded or decoded object.
     *         {@code null} if and only if there is no output object left in the
     *         product queue.
     */
    T poll();

    /**
     * Reads an encoded or decoded output from the head of the product queue.
     * The difference from {@link #poll()} is that it does not remove the
     * retrieved object from the product queue.
     *
     * @return an encoded or decoded object.
     *         {@code null} if and only if there is no output object left in the
     *         product queue.
     */
    T peek();
}
