/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet.faces;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeEventHandler;
import javax.portlet.faces.BridgePublicRenderParameterHandler;
import javax.portlet.faces.GenericFacesPortlet;
import javax.portlet.faces.MockBridge;
import org.jboss.portletbridge.AbstractAjax4jsfPortletTestCase;
import org.jboss.portletbridge.MockBridgeEventHandler;
import org.jboss.portletbridge.MockBridgePublicRenderParameterHandler;

public class GenericPortletTest
extends AbstractAjax4jsfPortletTestCase {
    private static final String FOO = "foo";

    public GenericPortletTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        MockBridge.actionCount = 0;
        MockBridge.destroyCount = 0;
        MockBridge.initCount = 0;
        MockBridge.responseCount = 0;
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDestroy() throws PortletException, IOException {
        this.setupActionRequest();
        GenericFacesPortlet portlet = new GenericFacesPortlet();
        this.portletContext.setInitParameter("javax.portlet.faces.BridgeImplClass", MockBridge.class.getName());
        portlet.init((PortletConfig)this.portletConfig);
        MockBridge facesPortletBridge = (MockBridge)portlet.getFacesBridge();
        GenericPortletTest.assertEquals((boolean)true, (boolean)facesPortletBridge.isInitialized());
        GenericPortletTest.assertEquals((int)1, (int)MockBridge.initCount);
        portlet.destroy();
        GenericPortletTest.assertEquals((int)1, (int)MockBridge.destroyCount);
        GenericPortletTest.assertEquals((boolean)false, (boolean)facesPortletBridge.isInitialized());
    }

    public void testInitPortletConfig() throws PortletException {
        this.servletContext.addInitParameter("javax.faces.LIFECYCLE_ID", "CUSTOM");
        this.servletContext.addInitParameter("javax.portlet.faces.renderPolicy", Bridge.BridgeRenderPolicy.NEVER_DELEGATE.toString());
        this.portletConfig.addInitParameter("javax.portlet.faces.preserveActionParams", "true");
        this.portletConfig.addInitParameter("javax.portlet.faces.excludedRequestAttributes", "bar,baz,boo");
        this.portletConfig.addInitParameter("javax.portlet.faces.extension.my_package.my_attribute", "xxx");
        GenericFacesPortlet portlet = this.createGenericPortlet();
        portlet.init((PortletConfig)this.portletConfig);
        GenericPortletTest.assertEquals((Object)Boolean.TRUE, (Object)this.portletContext.getAttribute("javax.portlet.faces.foo.preserveActionParams"));
        List attrsList = (List)this.portletContext.getAttribute("javax.portlet.faces.foo.excludedRequestAttributes");
        GenericPortletTest.assertEquals((int)3, (int)attrsList.size());
        GenericPortletTest.assertEquals((String)"bar", (String)((String)attrsList.get(0)));
        GenericPortletTest.assertEquals((String)"baz", (String)((String)attrsList.get(1)));
        GenericPortletTest.assertEquals((String)"boo", (String)((String)attrsList.get(2)));
        GenericPortletTest.assertEquals((Object)"xxx", (Object)this.portletContext.getAttribute("javax.portlet.faces.extension.my_package.foo.my_attribute"));
    }

    public void testDoDispatchRenderRequestRenderResponse() throws PortletException, IOException {
        this.setupRenderRequest();
        GenericFacesPortlet portlet = this.createGenericPortlet();
        this.portletConfig.addInitParameter("javax.portlet.faces.defaultViewId.view", "index.jsf");
        portlet.init((PortletConfig)this.portletConfig);
        portlet.doDispatch((RenderRequest)this.renderRequest, (RenderResponse)this.renderResponse);
        GenericPortletTest.assertEquals((int)1, (int)MockBridge.responseCount);
    }

    private GenericFacesPortlet createGenericPortlet() {
        GenericFacesPortlet portlet = new GenericFacesPortlet();
        this.portletContext.setInitParameter("javax.portlet.faces.BridgeImplClass", MockBridge.class.getName());
        this.portletConfig.setPortletName(FOO);
        return portlet;
    }

    public void testDoDispatchRenderRequestRenderResponseEdit() throws PortletException, IOException {
        this.setupRenderRequest();
        GenericFacesPortlet portlet = this.createGenericPortlet();
        this.portletConfig.addInitParameter("javax.portlet.faces.defaultViewId.edit", "index.jsf");
        this.renderRequest.mode = PortletMode.EDIT;
        portlet.init((PortletConfig)this.portletConfig);
        portlet.doDispatch((RenderRequest)this.renderRequest, (RenderResponse)this.renderResponse);
        GenericPortletTest.assertEquals((int)1, (int)MockBridge.responseCount);
    }

    public void testDoDispatchRenderRequestRenderResponseHelp() throws PortletException, IOException {
        this.setupRenderRequest();
        GenericFacesPortlet portlet = this.createGenericPortlet();
        this.portletConfig.addInitParameter("javax.portlet.faces.defaultViewId.help", "index.jsf");
        this.renderRequest.mode = PortletMode.HELP;
        portlet.init((PortletConfig)this.portletConfig);
        portlet.doDispatch((RenderRequest)this.renderRequest, (RenderResponse)this.renderResponse);
        GenericPortletTest.assertEquals((int)1, (int)MockBridge.responseCount);
    }

    public void testDoEditRenderRequestRenderResponse() throws PortletException, IOException {
        this.setupRenderRequest();
        this.portletConfig.addInitParameter("javax.portlet.faces.defaultViewId.view", "index.jsf");
        this.renderRequest.mode = PortletMode.EDIT;
        GenericFacesPortlet portlet = this.createGenericPortlet();
        portlet.init((PortletConfig)this.portletConfig);
        portlet.doDispatch((RenderRequest)this.renderRequest, (RenderResponse)this.renderResponse);
        GenericPortletTest.assertEquals((int)0, (int)MockBridge.responseCount);
    }

    public void testDoHelpRenderRequestRenderResponse() {
    }

    public void testDoViewRenderRequestRenderResponse() throws PortletException, IOException {
        this.setupRenderRequest();
        GenericFacesPortlet portlet = new GenericFacesPortlet();
        this.portletContext.setInitParameter("javax.portlet.faces.BridgeImplClass", MockBridge.class.getName());
        this.portletConfig.addInitParameter("javax.portlet.faces.defaultViewId.view", "index.jsf");
        portlet.init((PortletConfig)this.portletConfig);
        portlet.doDispatch((RenderRequest)this.renderRequest, (RenderResponse)this.renderResponse);
        GenericPortletTest.assertEquals((int)1, (int)MockBridge.responseCount);
    }

    public void testProcessActionActionRequestActionResponse() throws PortletException, IOException {
        this.setupActionRequest();
        GenericFacesPortlet portlet = new GenericFacesPortlet();
        this.portletContext.setInitParameter("javax.portlet.faces.BridgeImplClass", MockBridge.class.getName());
        this.portletConfig.addInitParameter("javax.portlet.faces.defaultViewId.view", "index.jsf");
        portlet.init((PortletConfig)this.portletConfig);
        portlet.processAction((ActionRequest)this.actionRequest, (ActionResponse)this.actionResponse);
        GenericPortletTest.assertEquals((int)1, (int)MockBridge.actionCount);
    }

    public void testProcessResource() throws Exception {
        this.setupResourceRequest();
        GenericFacesPortlet portlet = this.createGenericPortlet();
        portlet.init((PortletConfig)this.portletConfig);
        portlet.serveResource((ResourceRequest)this.resourceRequest, (ResourceResponse)this.resourceResponse);
        GenericPortletTest.assertEquals((int)1, (int)MockBridge.resourceCount);
    }

    public void testProcessEvent() throws Exception {
        this.setupEventRequest();
        GenericFacesPortlet portlet = this.createGenericPortlet();
        portlet.init((PortletConfig)this.portletConfig);
        portlet.processEvent((EventRequest)this.eventRequest, (EventResponse)this.eventResponse);
        GenericPortletTest.assertEquals((int)1, (int)MockBridge.eventCount);
    }

    public void testGetBridgeClassName() throws PortletException {
        this.setupActionRequest();
        GenericFacesPortlet portlet = new GenericFacesPortlet();
        this.portletContext.setInitParameter("javax.portlet.faces.BridgeImplClass", MockBridge.class.getName());
        this.portletContext.setInitParameter("javax.portlet.faces.defaultViewId.view", "index.jsf");
        portlet.init((PortletConfig)this.portletConfig);
        GenericPortletTest.assertEquals((String)MockBridge.class.getName(), (String)portlet.getBridgeClassName());
    }

    public void testGetBridgeClassName1() throws PortletException {
        this.setupActionRequest();
        GenericFacesPortlet portlet = new GenericFacesPortlet();
        try {
            portlet.init((PortletConfig)this.portletConfig);
        }
        catch (PortletException e) {
            GenericPortletTest.assertEquals((String)"Can't detect bridge implementation class name", (String)e.getMessage());
            return;
        }
        GenericPortletTest.assertTrue((String)"No exception for unknown bridge implementation", (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetBridgeClassName2() throws PortletException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassLoader testLoader = new ClassLoader(loader){

            public URL getResource(String name) {
                if ("META-INF/services/javax.portlet.faces.Bridge".equals(name)) {
                    return super.getResource("javax.portlet.faces.Bridge.test");
                }
                return super.getResource(name);
            }
        };
        try {
            Thread.currentThread().setContextClassLoader(testLoader);
            this.setupActionRequest();
            GenericFacesPortlet portlet = new GenericFacesPortlet(){

                public PortletContext getPortletContext() {
                    return GenericPortletTest.this.portletContext;
                }
            };
            GenericPortletTest.assertEquals((String)MockBridge.class.getName(), (String)portlet.getBridgeClassName());
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    public void testGetDefaultViewIdMap() throws PortletException {
        this.portletConfig.addInitParameter("javax.portlet.faces.defaultViewId.view", "index.jsf");
        this.portletConfig.addInitParameter("javax.portlet.faces.defaultViewId.edit", "edit/index.jsf");
        this.portletConfig.addInitParameter("javax.portlet.faces.defaultViewId.help", "help/index.jsf");
        GenericFacesPortlet portlet = this.createGenericPortlet();
        portlet.init((PortletConfig)this.portletConfig);
        Map viewIdMap = portlet.getDefaultViewIdMap();
        GenericPortletTest.assertEquals((int)3, (int)viewIdMap.size());
        GenericPortletTest.assertEquals((String)"index.jsf", (String)((String)viewIdMap.get(PortletMode.VIEW.toString())));
        GenericPortletTest.assertEquals((String)"edit/index.jsf", (String)((String)viewIdMap.get(PortletMode.EDIT.toString())));
        GenericPortletTest.assertEquals((String)"help/index.jsf", (String)((String)viewIdMap.get(PortletMode.HELP.toString())));
        GenericPortletTest.assertEquals((Object)viewIdMap, (Object)this.portletContext.getAttribute("javax.portlet.faces.foo.defaultViewIdMap"));
    }

    public void testGetFacesPortletBridge() throws PortletException {
        this.setupActionRequest();
        GenericFacesPortlet portlet = new GenericFacesPortlet();
        this.portletContext.setInitParameter("javax.portlet.faces.BridgeImplClass", MockBridge.class.getName());
        portlet.init((PortletConfig)this.portletConfig);
        Bridge facesPortletBridge = portlet.getFacesBridge();
        GenericPortletTest.assertTrue((boolean)(facesPortletBridge instanceof MockBridge));
        GenericPortletTest.assertEquals((boolean)true, (boolean)((MockBridge)facesPortletBridge).isInitialized());
    }

    public void testGetExcludedRequestAttributes() throws Exception {
        this.portletConfig.addInitParameter("javax.portlet.faces.excludedRequestAttributes", "foo.*,bar.baz.*");
        GenericFacesPortlet portlet = this.createGenericPortlet();
        portlet.init((PortletConfig)this.portletConfig);
        List attributes = portlet.getExcludedRequestAttributes();
        GenericPortletTest.assertEquals((int)2, (int)attributes.size());
        GenericPortletTest.assertTrue((boolean)attributes.contains("foo.*"));
        GenericPortletTest.assertTrue((boolean)attributes.contains("bar.baz.*"));
        GenericPortletTest.assertEquals((Object)attributes, (Object)this.portletContext.getAttribute("javax.portlet.faces.foo.excludedRequestAttributes"));
    }

    public void testIsPreserveActionParams() throws Exception {
        this.portletConfig.addInitParameter("javax.portlet.faces.preserveActionParams", "true");
        GenericFacesPortlet portlet = this.createGenericPortlet();
        portlet.init((PortletConfig)this.portletConfig);
        GenericPortletTest.assertTrue((boolean)portlet.isPreserveActionParameters());
        GenericPortletTest.assertEquals((Object)Boolean.TRUE, (Object)this.portletContext.getAttribute("javax.portlet.faces.foo.preserveActionParams"));
    }

    public void testIsPreserveActionParamsFalse() throws Exception {
        GenericFacesPortlet portlet = this.createGenericPortlet();
        portlet.init((PortletConfig)this.portletConfig);
        GenericPortletTest.assertFalse((boolean)portlet.isPreserveActionParameters());
    }

    public void testGetBridgeEventHandler() throws Exception {
        this.portletConfig.addInitParameter("javax.portlet.faces.bridgeEventHandler", MockBridgeEventHandler.class.getName());
        GenericFacesPortlet portlet = this.createGenericPortlet();
        portlet.init((PortletConfig)this.portletConfig);
        BridgeEventHandler eventHandler = portlet.getBridgeEventHandler();
        GenericPortletTest.assertNotNull((Object)eventHandler);
        GenericPortletTest.assertTrue((boolean)(eventHandler instanceof MockBridgeEventHandler));
        Object handler = this.portletContext.getAttribute("javax.portlet.faces.foo.bridgeEventHandler");
        GenericPortletTest.assertNotNull((Object)handler);
        GenericPortletTest.assertTrue((boolean)(handler instanceof MockBridgeEventHandler));
    }

    public void testGetBridgePublicRenderParameterHandler() throws Exception {
        this.portletConfig.addInitParameter("javax.portlet.faces.bridgePublicRenderParameterHandler", MockBridgePublicRenderParameterHandler.class.getName());
        GenericFacesPortlet portlet = this.createGenericPortlet();
        portlet.init((PortletConfig)this.portletConfig);
        BridgePublicRenderParameterHandler eventHandler = portlet.getBridgePublicRenderParameterHandler();
        GenericPortletTest.assertNotNull((Object)eventHandler);
        GenericPortletTest.assertTrue((boolean)(eventHandler instanceof MockBridgePublicRenderParameterHandler));
        Object handler = this.portletContext.getAttribute("javax.portlet.faces.foo.bridgePublicRenderParameterHandler");
        GenericPortletTest.assertNotNull((Object)handler);
        GenericPortletTest.assertTrue((boolean)(handler instanceof MockBridgePublicRenderParameterHandler));
    }

    private final class GenericFacesPortletExtension
    extends GenericFacesPortlet {
        boolean editProcessed = false;
        boolean viewProcessed = false;
        boolean helpProcessed = false;

        private GenericFacesPortletExtension() {
        }

        protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
            this.editProcessed = true;
        }

        protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
            this.viewProcessed = true;
        }

        protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
            this.helpProcessed = true;
        }
    }
}

