/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.jboss.remoting3.ReplyException;
import org.jboss.remoting3.TypedRequest;
import org.jboss.remoting3.spi.LocalReplyHandler;
import org.jboss.xnio.AbstractIoFuture;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.IoFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FutureReplyImpl<O>
extends AbstractIoFuture<O> {
    private final Executor executor;
    private final Checker<? extends O> checker;
    private final ClassLoader classLoader;
    private final LocalReplyHandler replyHandler = new Handler();
    private volatile Cancellable remoteRequestContext;

    FutureReplyImpl(Executor executor, Checker<? extends O> checker, ClassLoader classLoader) {
        this.executor = executor;
        this.checker = checker;
        this.classLoader = classLoader;
    }

    FutureReplyImpl(Executor executor, final Class<? extends O> expectedType, ClassLoader classLoader) {
        this(executor, new Checker<O>(){

            @Override
            public O cast(Object input) {
                return expectedType.cast(input);
            }
        }, classLoader);
    }

    FutureReplyImpl(Executor executor, final TypedRequest<?, ? extends O> typedRequest, ClassLoader classLoader) {
        this(executor, new Checker<O>(){

            @Override
            public O cast(Object input) {
                return typedRequest.castReply(input);
            }
        }, classLoader);
    }

    void setRemoteRequestContext(Cancellable remoteRequestContext) {
        this.remoteRequestContext = remoteRequestContext;
    }

    public IoFuture<O> cancel() {
        this.remoteRequestContext.cancel();
        return this;
    }

    protected Executor getNotifierExecutor() {
        return this.executor;
    }

    LocalReplyHandler getReplyHandler() {
        return this.replyHandler;
    }

    private final class Handler
    implements LocalReplyHandler {
        private Handler() {
        }

        public void handleReply(Object reply) {
            Object actualReply;
            Checker checker = FutureReplyImpl.this.checker;
            try {
                actualReply = checker.cast(reply);
            }
            catch (ClassCastException e) {
                FutureReplyImpl.this.setException(new ReplyException("Reply was of unexpected type " + reply.getClass().getName()));
                return;
            }
            FutureReplyImpl.this.setResult(actualReply);
        }

        public void handleException(IOException exception) {
            FutureReplyImpl.this.setException(exception);
        }

        public void handleCancellation() {
            FutureReplyImpl.this.setCancelled();
        }

        public ClassLoader getClassLoader() {
            return FutureReplyImpl.this.classLoader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Checker<O> {
        public O cast(Object var1);
    }
}

