/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.stream;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Pair;
import org.jboss.remoting3.stream.ObjectSink;
import org.jboss.remoting3.stream.ObjectSource;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.FutureResult;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Streams {
    private Streams() {
    }

    public static <T> ObjectSink<T> getCollectionObjectSink(Collection<T> target) {
        return new CollectionObjectSink(target);
    }

    public static <T> ObjectSource<T> getIteratorObjectSource(Iterator<T> iterator) {
        return new IteratorObjectSource(iterator);
    }

    public static <T> ObjectSource<T> getCollectionObjectSource(Collection<T> collection) {
        return Streams.getIteratorObjectSource(collection.iterator());
    }

    public static <K, V> ObjectSink<Pair<K, V>> getMapObjectSink(Map<K, V> target) {
        return new MapObjectSink(target);
    }

    public static <T> ObjectSink<T> getCheckedObjectSink(ObjectSink<T> delegate, Class<? extends T> clazz) {
        return new CheckedObjectSink(delegate, clazz);
    }

    public static <K, V> ObjectSource<Pair<K, V>> getMapEntryIteratorObjectSource(Iterator<Map.Entry<K, V>> iterator) {
        return new MapEntryIteratorObjectSource(iterator);
    }

    public static <K, V> ObjectSource<Pair<K, V>> getMapObjectSource(Map<K, V> map) {
        return Streams.getMapEntryIteratorObjectSource(map.entrySet().iterator());
    }

    public static <C extends Collection<T>, T> C getCollection(C newCollection, ObjectSource<T> objectSource) throws IOException {
        while (objectSource.hasNext()) {
            newCollection.add(objectSource.next());
        }
        return newCollection;
    }

    public static <M extends Map<K, V>, K, V> M getMap(M newMap, ObjectSource<Pair<K, V>> objectSource) throws IOException {
        while (objectSource.hasNext()) {
            Pair<K, V> pair = objectSource.next();
            newMap.put((Object)pair.getA(), (Object)pair.getB());
        }
        return newMap;
    }

    public static <C extends Collection<T>, T> IoFuture<? extends C> getFutureCollection(Executor executor, final C newCollection, final ObjectSource<T> objectSource) {
        final FutureResult futureResult = new FutureResult(executor);
        futureResult.addCancelHandler(new Cancellable(){

            public Cancellable cancel() {
                if (futureResult.setCancelled()) {
                    IoUtils.safeClose((Closeable)objectSource);
                }
                return this;
            }
        });
        try {
            executor.execute(new Runnable(){

                public void run() {
                    try {
                        while (objectSource.hasNext()) {
                            newCollection.add(objectSource.next());
                        }
                        futureResult.setResult((Object)newCollection);
                    }
                    catch (IOException e) {
                        futureResult.setException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            IOException ioe = new IOException("Failed to initiate asynchronous population of a collection");
            ioe.initCause(e);
            futureResult.setException(ioe);
        }
        return futureResult.getIoFuture();
    }

    public static <M extends Map<K, V>, K, V> IoFuture<? extends M> getFutureMap(Executor executor, final M newMap, final ObjectSource<Pair<K, V>> objectSource) {
        final FutureResult futureResult = new FutureResult(executor);
        futureResult.addCancelHandler(new Cancellable(){

            public Cancellable cancel() {
                if (futureResult.setCancelled()) {
                    IoUtils.safeClose((Closeable)objectSource);
                }
                return this;
            }
        });
        try {
            executor.execute(new Runnable(){

                public void run() {
                    try {
                        while (objectSource.hasNext()) {
                            Pair pair = (Pair)objectSource.next();
                            newMap.put(pair.getA(), pair.getB());
                        }
                        futureResult.setResult((Object)newMap);
                    }
                    catch (IOException e) {
                        futureResult.setException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            IOException ioe = new IOException("Failed to initiate asynchronous population of a collection");
            ioe.initCause(e);
            futureResult.setException(ioe);
        }
        return futureResult.getIoFuture();
    }

    public static <T> ObjectSource<T> getEnumerationObjectSource(Enumeration<T> enumeration) {
        return new EnumerationObjectSource(enumeration);
    }

    public static void copyStream(InputStream input, OutputStream output, boolean close, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        try {
            while (true) {
                int res;
                if ((res = input.read(buffer)) == -1) {
                    if (close) {
                        input.close();
                        output.close();
                    }
                    return;
                }
                output.write(buffer, 0, res);
            }
        }
        finally {
            if (close) {
                IoUtils.safeClose((Closeable)input);
                IoUtils.safeClose((Closeable)output);
            }
        }
    }

    public static void copyStream(InputStream input, OutputStream output, boolean close) throws IOException {
        Streams.copyStream(input, output, close, 8192);
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        Streams.copyStream(input, output, true, 8192);
    }

    public static void copyStream(ByteInput input, ByteOutput output, boolean close, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        try {
            while (true) {
                int res;
                if ((res = input.read(buffer)) == -1) {
                    if (close) {
                        input.close();
                        output.close();
                    }
                    return;
                }
                output.write(buffer, 0, res);
            }
        }
        finally {
            if (close) {
                IoUtils.safeClose((Closeable)input);
                IoUtils.safeClose((Closeable)output);
            }
        }
    }

    public static void copyStream(ByteInput input, ByteOutput output, boolean close) throws IOException {
        Streams.copyStream(input, output, close, 8192);
    }

    public static void copyStream(ByteInput input, ByteOutput output) throws IOException {
        Streams.copyStream(input, output, true, 8192);
    }

    static Charset getCharset(String charsetName) throws UnsupportedEncodingException {
        try {
            return Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckedObjectSink<T>
    implements ObjectSink<T> {
        private final ObjectSink<T> delegate;
        private final Class<? extends T> clazz;

        private CheckedObjectSink(ObjectSink<T> delegate, Class<? extends T> clazz) {
            this.delegate = delegate;
            this.clazz = clazz;
        }

        @Override
        public void accept(T instance) throws IOException {
            this.delegate.accept(this.clazz.cast(instance));
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapEntryIteratorObjectSource<K, V>
    implements ObjectSource<Pair<K, V>> {
        private final Iterator<Map.Entry<K, V>> source;

        private MapEntryIteratorObjectSource(Iterator<Map.Entry<K, V>> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.source.hasNext();
        }

        @Override
        public Pair<K, V> next() throws NoSuchElementException, IOException {
            Map.Entry<K, V> entry = this.source.next();
            return Pair.create(entry.getKey(), entry.getValue());
        }

        @Override
        public void close() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapObjectSink<K, V>
    implements ObjectSink<Pair<K, V>> {
        private final Map<K, V> target;

        private MapObjectSink(Map<K, V> target) {
            this.target = target;
        }

        @Override
        public void accept(Pair<K, V> instance) throws IOException {
            this.target.put(instance.getA(), instance.getB());
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnumerationObjectSource<T>
    implements ObjectSource<T> {
        private final Enumeration<T> src;

        private EnumerationObjectSource(Enumeration<T> src) {
            this.src = src;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.src.hasMoreElements();
        }

        @Override
        public T next() throws IOException {
            try {
                return this.src.nextElement();
            }
            catch (NoSuchElementException ex) {
                EOFException eex = new EOFException("Read past end of enumeration");
                eex.setStackTrace(ex.getStackTrace());
                throw eex;
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IteratorObjectSource<T>
    implements ObjectSource<T> {
        private final Iterator<T> src;

        private IteratorObjectSource(Iterator<T> src) {
            this.src = src;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.src.hasNext();
        }

        @Override
        public T next() throws IOException {
            try {
                return this.src.next();
            }
            catch (NoSuchElementException ex) {
                EOFException eex = new EOFException("Iteration past end of iterator");
                eex.setStackTrace(ex.getStackTrace());
                throw eex;
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CollectionObjectSink<T>
    implements ObjectSink<T> {
        private final Collection<T> target;

        private CollectionObjectSink(Collection<T> target) {
            this.target = target;
        }

        @Override
        public void accept(T instance) throws IOException {
            this.target.add(instance);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

