/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jboss.remoting3.MessageCancelledException;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.remote.IntIndexer;
import org.jboss.remoting3.remote.RemoteConnectionChannel;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.WritableMessageChannel;
import org.xnio.streams.BufferPipeInputStream;

final class InboundMessage {
    final short messageId;
    final RemoteConnectionChannel channel;
    int inboundWindow;
    boolean closed;
    boolean cancelled;
    static final IntIndexer<InboundMessage> INDEXER = new IntIndexer<InboundMessage>(){

        @Override
        public int getKey(InboundMessage argument) {
            return argument.messageId & 0xFFFF;
        }

        public boolean equals(InboundMessage argument, int index) {
            return (argument.messageId & 0xFFFF) == index;
        }
    };
    final BufferPipeInputStream inputStream = new BufferPipeInputStream(new BufferPipeInputStream.InputHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acknowledge(Pooled<ByteBuffer> acked) throws IOException {
            int consumed = ((ByteBuffer)acked.getResource()).position();
            InboundMessage.this.openInboundWindow(consumed);
            Pooled<ByteBuffer> pooled = InboundMessage.this.allocate((byte)49);
            try {
                ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                buffer.putInt(consumed);
                buffer.flip();
                Channels.sendBlocking((WritableMessageChannel)InboundMessage.this.channel.getRemoteConnection().getChannel(), (ByteBuffer)buffer);
            }
            finally {
                pooled.free();
            }
        }

        public void close() throws IOException {
            InboundMessage.this.sendAsyncClose();
        }
    });
    final MessageInputStream messageInputStream = new MessageInputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            BufferPipeInputStream bufferPipeInputStream = InboundMessage.this.inputStream;
            synchronized (bufferPipeInputStream) {
                if (InboundMessage.this.cancelled) {
                    throw new MessageCancelledException();
                }
                return InboundMessage.this.inputStream.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] bytes, int offs, int length) throws IOException {
            BufferPipeInputStream bufferPipeInputStream = InboundMessage.this.inputStream;
            synchronized (bufferPipeInputStream) {
                if (InboundMessage.this.cancelled) {
                    throw new MessageCancelledException();
                }
                return InboundMessage.this.inputStream.read(bytes, offs, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long l) throws IOException {
            BufferPipeInputStream bufferPipeInputStream = InboundMessage.this.inputStream;
            synchronized (bufferPipeInputStream) {
                if (InboundMessage.this.cancelled) {
                    throw new MessageCancelledException();
                }
                return InboundMessage.this.inputStream.skip(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            BufferPipeInputStream bufferPipeInputStream = InboundMessage.this.inputStream;
            synchronized (bufferPipeInputStream) {
                if (InboundMessage.this.cancelled) {
                    throw new MessageCancelledException();
                }
                return InboundMessage.this.inputStream.available();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            BufferPipeInputStream bufferPipeInputStream = InboundMessage.this.inputStream;
            synchronized (bufferPipeInputStream) {
                if (InboundMessage.this.cancelled) {
                    throw new MessageCancelledException();
                }
                InboundMessage.this.inputStream.close();
            }
        }
    };

    InboundMessage(short messageId, RemoteConnectionChannel channel, int inboundWindow) {
        this.messageId = messageId;
        this.channel = channel;
        this.inboundWindow = inboundWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAsyncClose() throws IOException {
        Pooled<ByteBuffer> pooled = this.allocate((byte)50);
        try {
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            buffer.flip();
            Channels.sendBlocking((WritableMessageChannel)this.channel.getRemoteConnection().getChannel(), (ByteBuffer)buffer);
        }
        finally {
            pooled.free();
        }
    }

    Pooled<ByteBuffer> allocate(byte protoId) {
        Pooled<ByteBuffer> pooled = this.channel.allocate(protoId);
        ByteBuffer buffer = (ByteBuffer)pooled.getResource();
        buffer.putShort(this.messageId);
        return pooled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openInboundWindow(int consumed) {
        BufferPipeInputStream bufferPipeInputStream = this.inputStream;
        synchronized (bufferPipeInputStream) {
            this.inboundWindow += consumed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInboundWindow(int produced) {
        BufferPipeInputStream bufferPipeInputStream = this.inputStream;
        synchronized (bufferPipeInputStream) {
            if ((this.inboundWindow -= produced) < 0) {
                this.channel.getRemoteConnection().handleException(new IOException("Input overrun"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleIncoming(Pooled<ByteBuffer> pooledBuffer) {
        BufferPipeInputStream bufferPipeInputStream = this.inputStream;
        synchronized (bufferPipeInputStream) {
            boolean cancelled;
            boolean eof;
            if (this.closed) {
                pooledBuffer.free();
                return;
            }
            if (this.inboundWindow == 0) {
                pooledBuffer.free();
                try {
                    this.sendAsyncClose();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return;
            }
            ByteBuffer buffer = (ByteBuffer)pooledBuffer.getResource();
            this.closeInboundWindow(buffer.remaining() - 8);
            buffer.position(buffer.position() - 1);
            byte flags = buffer.get();
            boolean bl = eof = (flags & 1) != 0;
            if (eof) {
                this.closed = true;
                this.channel.freeInboundMessage(this.messageId);
            }
            boolean bl2 = cancelled = (flags & 4) != 0;
            if (cancelled) {
                this.cancelled = true;
            }
            this.inputStream.push(pooledBuffer);
            if (eof) {
                this.inputStream.pushEof();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        BufferPipeInputStream bufferPipeInputStream = this.inputStream;
        synchronized (bufferPipeInputStream) {
            if (this.closed || this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.closed = true;
            this.inputStream.pushEof();
        }
    }
}

