/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.metadata;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.beans.metadata.spi.builder.ParameterMetaDataBuilder;
import org.jboss.remoting3.Client;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.RequestListener;
import org.jboss.remoting3.metadata.ClientAuthenticationMetaData;
import org.jboss.remoting3.metadata.ConnectionMetaData;
import org.jboss.remoting3.metadata.EndpointMetaData;
import org.jboss.remoting3.metadata.LocalClientMetaData;
import org.jboss.remoting3.metadata.RefMetaData;
import org.jboss.remoting3.metadata.RemotingHelper;
import org.jboss.remoting3.metadata.ServerMetaData;
import org.jboss.remoting3.metadata.ServiceManager;
import org.jboss.remoting3.metadata.ServiceMetaData;
import org.jboss.remoting3.metadata.SimpleServerAuthenticationMetaData;
import org.jboss.remoting3.metadata.UserEntryMetaData;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.security.SimpleClientCallbackHandler;
import org.jboss.remoting3.security.SimpleServerAuthenticationProvider;
import org.jboss.xb.annotations.JBossXmlSchema;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.Option;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.SslTcpConnector;
import org.jboss.xnio.TcpConnector;
import org.jboss.xnio.metadata.OptionMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JBossXmlSchema(namespace="urn:jboss:remoting:3.1", elementFormDefault=XmlNsForm.QUALIFIED)
@XmlRootElement(name="remoting")
@XmlType(name="remoting", propOrder={})
public class RemotingMetaData
implements BeanMetaDataFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private String endpoint;
    private List<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
    private List<LocalClientMetaData> localClients = new ArrayList<LocalClientMetaData>();
    private List<ServerMetaData> servers = new ArrayList<ServerMetaData>();
    private List<ConnectionMetaData> connections = new ArrayList<ConnectionMetaData>();
    private List<EndpointMetaData> endpoints = new ArrayList<EndpointMetaData>();
    private List<SimpleServerAuthenticationMetaData> simpleServerAuthentications = new ArrayList<SimpleServerAuthenticationMetaData>();

    public String getEndpoint() {
        return this.endpoint;
    }

    @XmlAttribute(name="endpoint")
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public List<ServiceMetaData> getServices() {
        return this.services;
    }

    @XmlElement(name="local-service")
    public void setServices(List<ServiceMetaData> services) {
        this.services = services;
    }

    public List<LocalClientMetaData> getLocalClients() {
        return this.localClients;
    }

    @XmlElement(name="client")
    public void setLocalClients(List<LocalClientMetaData> localClients) {
        this.localClients = localClients;
    }

    public List<ServerMetaData> getServers() {
        return this.servers;
    }

    @XmlElement(name="server")
    public void setServers(List<ServerMetaData> servers) {
        this.servers = servers;
    }

    public List<ConnectionMetaData> getConnections() {
        return this.connections;
    }

    @XmlElement(name="connection")
    public void setConnections(List<ConnectionMetaData> connections) {
        this.connections = connections;
    }

    public List<EndpointMetaData> getEndpoints() {
        return this.endpoints;
    }

    @XmlElement(name="endpoint", required=true)
    public void setEndpoints(List<EndpointMetaData> endpoints) {
        this.endpoints = endpoints;
    }

    public List<SimpleServerAuthenticationMetaData> getSimpleServerAuthentications() {
        return this.simpleServerAuthentications;
    }

    @XmlElement(name="simple-server-authentication")
    public void setSimpleServerAuthentications(List<SimpleServerAuthenticationMetaData> simpleServerAuthentications) {
        this.simpleServerAuthentications = simpleServerAuthentications;
    }

    @XmlTransient
    public List<BeanMetaData> getBeans() {
        String password;
        BeanMetaDataBuilder builder;
        String name;
        String endpoint = "Remoting:ENDPOINT:" + this.endpoint;
        ArrayList<BeanMetaData> metaDataList = new ArrayList<BeanMetaData>();
        for (ServiceMetaData service : this.services) {
            String type = service.getType();
            String groupName = RemotingMetaData.defaulted(service.getGroupName(), "default");
            BeanMetaDataBuilder builder2 = BeanMetaDataBuilder.createBuilder((String)("Remoting:" + endpoint + ":SERVICE:" + type + ":" + groupName), (String)ServiceManager.class.getName());
            builder2.ignoreCreate();
            builder2.ignoreDestroy();
            builder2.setStart("start");
            builder2.setStop("stop");
            builder2.addPropertyMetaData("endpoint", builder2.createInject((Object)endpoint));
            builder2.addPropertyMetaData("requestType", service.getRequestClassName().getName());
            builder2.addPropertyMetaData("replyType", service.getReplyClassName().getName());
            builder2.addPropertyMetaData("clientListener", builder2.createInject((Object)service.getClientListener()));
            builder2.addPropertyMetaData("optionMap", (Object)this.createOptionMap(service.getOptions()));
            builder2.addPropertyMetaData("serviceType", service.getType());
            RefMetaData classloader = service.getClassloader();
            if (classloader != null) {
                builder2.addPropertyMetaData("classloader", builder2.createInject((Object)classloader.getName()));
            }
            builder2.addPropertyMetaData("groupName", service.getGroupName());
            metaDataList.add(builder2.getBeanMetaData());
        }
        for (LocalClientMetaData localClient : this.localClients) {
            name = localClient.getName();
            builder = BeanMetaDataBuilder.createBuilder((String)name, (String)Client.class.getName());
            builder.ignoreCreate();
            builder.ignoreDestroy();
            builder.ignoreStart();
            builder.setStop("close");
            builder.setFactoryClass(Remoting.class.getName());
            builder.setFactoryMethod("createLocalClient");
            builder.addConstructorParameter(Endpoint.class.getName(), builder.createInject((Object)endpoint));
            builder.addConstructorParameter(RequestListener.class.getName(), builder.createInject((Object)localClient.getRequestListener().getName()));
            builder.addConstructorParameter(Class.class.getName(), localClient.getRequestClassName().getName());
            metaDataList.add(builder.getBeanMetaData());
        }
        for (ServerMetaData server : this.servers) {
            name = server.getName();
            builder = BeanMetaDataBuilder.createBuilder((String)name, (String)ChannelListener.class.getName());
            builder.ignoreCreate();
            builder.ignoreDestroy();
            builder.ignoreStart();
            builder.ignoreStop();
            builder.setFactoryClass(RemotingHelper.class.getName());
            builder.setFactoryMethod("createServer");
            builder.addConstructorParameter(Endpoint.class.getName(), builder.createInject((Object)endpoint));
            builder.addConstructorParameter(String.class.getName(), server.getProtocol());
            builder.addConstructorParameter(OptionMap.class.getName(), (Object)this.createOptionMap(server.getOptions()));
            RefMetaData handlerRef = server.getAuthenticationHandler();
            if (handlerRef == null) {
                throw new IllegalArgumentException("No authentication-provider specified for server " + name);
            }
            builder.addConstructorParameter(ServerAuthenticationProvider.class.getName(), builder.createInject((Object)("Remoting:AUTH:" + handlerRef.getName())));
            metaDataList.add(builder.getBeanMetaData());
        }
        for (ConnectionMetaData connection : this.connections) {
            name = connection.getName();
            builder = BeanMetaDataBuilder.createBuilder((String)name, (String)Connection.class.getName());
            builder.ignoreCreate();
            builder.ignoreDestroy();
            builder.ignoreStart();
            builder.setStop("close");
            builder.setFactory(endpoint);
            builder.setFactoryMethod("connect");
            builder.addConstructorParameter(URI.class.getName(), (Object)URI.create(connection.getDestination().getName()));
            builder.addConstructorParameter(OptionMap.class.getName(), (Object)this.createOptionMap(connection.getOptions()));
            ClientAuthenticationMetaData auth = connection.getClientAuthentication();
            if (auth != null) {
                RefMetaData ref = auth.getCallbackHandler();
                if (ref != null) {
                    builder.addConstructorParameter(CallbackHandler.class.getName(), builder.createInject((Object)ref.getName()));
                } else {
                    UserEntryMetaData entry = auth.getUserEntry();
                    password = entry.getPassword();
                    builder.addConstructorParameter(CallbackHandler.class.getName(), (Object)new SimpleClientCallbackHandler(entry.getUserName(), entry.getRealmName(), password == null ? null : password.toCharArray()));
                }
            }
            metaDataList.add(builder.getBeanMetaData());
        }
        for (EndpointMetaData endpointMetaData : this.endpoints) {
            name = endpointMetaData.getName();
            builder = BeanMetaDataBuilder.createBuilder((String)("Remoting:ENDPOINT:" + name), (String)Endpoint.class.getName());
            builder.ignoreCreate();
            builder.ignoreDestroy();
            builder.ignoreStart();
            builder.setStop("close");
            builder.setFactoryClass(RemotingHelper.class.getName());
            builder.setFactoryMethod("createEndpoint");
            builder.addConstructorParameter(String.class.getName(), name);
            builder.addConstructorParameter(TcpConnector.class.getName(), builder.createInject((Object)endpointMetaData.getTcpConnector().getName()));
            RefMetaData sslRef = endpointMetaData.getSslConnector();
            builder.addConstructorParameter(SslTcpConnector.class.getName(), sslRef == null ? builder.createNull() : builder.createInject((Object)sslRef.getName()));
            builder.addConstructorParameter(Executor.class.getName(), builder.createInject((Object)endpointMetaData.getExecutor().getName()));
            builder.addConstructorParameter(OptionMap.class.getName(), (Object)this.createOptionMap(endpointMetaData.getOptions()));
            metaDataList.add(builder.getBeanMetaData());
        }
        for (SimpleServerAuthenticationMetaData metaData : this.simpleServerAuthentications) {
            name = metaData.getName();
            builder = BeanMetaDataBuilder.createBuilder((String)("Remoting:AUTH:" + name), (String)SimpleServerAuthenticationProvider.class.getName());
            builder.ignoreCreate();
            builder.ignoreDestroy();
            builder.ignoreStart();
            builder.ignoreStop();
            for (UserEntryMetaData entry : metaData.getUsers()) {
                ParameterMetaDataBuilder paramBuilder = builder.addInstallWithParameters("addUser");
                paramBuilder.addParameterMetaData(String.class.getName(), entry.getUserName());
                paramBuilder.addParameterMetaData(String.class.getName(), entry.getRealmName());
                password = entry.getPassword();
                paramBuilder.addParameterMetaData(char[].class.getName(), (Object)(password == null ? null : password.toCharArray()));
            }
            metaDataList.add(builder.getBeanMetaData());
        }
        return metaDataList;
    }

    private OptionMap createOptionMap(List<OptionMetaData> options) {
        if (options.isEmpty()) {
            return OptionMap.EMPTY;
        }
        OptionMap.Builder builder = OptionMap.builder();
        for (OptionMetaData option : options) {
            Option real;
            String className = option.getClassName();
            if (className == null || className.length() == 0) {
                Option test;
                try {
                    test = Option.fromString((String)(RemotingOptions.class.getName() + "." + option.getName()), (ClassLoader)Remoting.class.getClassLoader());
                }
                catch (IllegalArgumentException e) {
                    test = Option.fromString((String)(Options.class.getName() + "." + option.getName()), (ClassLoader)Remoting.class.getClassLoader());
                }
                real = test;
            } else {
                real = Option.fromString((String)(className + "." + option.getName()), (ClassLoader)Remoting.class.getClassLoader());
            }
            builder.parse(real, option.getValue());
        }
        return builder.getMap();
    }

    private static String defaulted(String val, String def) {
        return val != null ? val : def;
    }
}

