/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.api;

import java.security.AccessController;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.GetTcclAction;
import org.jboss.shrinkwrap.descriptor.spi.NodeProvider;

class DescriptorConstructionInfo {
    final Class<? extends NodeProvider> implClass;
    final Class<? extends DescriptorImporter<?>> importerClass;
    final String defaultName;

    DescriptorConstructionInfo(String implClassName, String importerClassName, String defaultName) {
        Class<?> importerClass;
        Class<?> implClass;
        ClassLoader tccl = AccessController.doPrivileged(GetTcclAction.INSTANCE);
        try {
            implClass = Class.forName(implClassName, false, tccl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load specified implementation class from " + tccl + ": " + implClassName, e);
        }
        this.implClass = implClass;
        try {
            importerClass = Class.forName(importerClassName, false, tccl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load specified importer class from " + tccl + ": " + importerClassName, e);
        }
        this.importerClass = importerClass;
        this.defaultName = defaultName;
    }
}

