/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.shrinkwrap.descriptor.api.query.Queries;
import org.jboss.shrinkwrap.descriptor.api.query.Query;
import org.jboss.shrinkwrap.descriptor.impl.base.query.CreateQuery;
import org.jboss.shrinkwrap.descriptor.impl.base.query.GetOrCreateQuery;
import org.jboss.shrinkwrap.descriptor.impl.base.query.GetQuery;
import org.jboss.shrinkwrap.descriptor.impl.base.query.GetSingleQuery;

public class Node {
    private final Node parent;
    private List<Node> children = new ArrayList<Node>();
    private final String name;
    private Map<String, String> attributes;
    private String text;

    public Node(String name) {
        this(name, null);
    }

    public Node(String name, Node parent) {
        this.name = name;
        this.parent = parent;
        if (this.parent != null) {
            this.parent.children.add(this);
        }
    }

    public Node attribute(String name, Object value) {
        return this.attribute(name, String.valueOf(value));
    }

    public Node attribute(String name, String value) {
        this.attributes().put(name, value);
        return this;
    }

    public String attribute(String name) {
        return this.attributes().get(name);
    }

    public Map<String, String> attributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public Node create(String name) {
        return this.create(Queries.from(name));
    }

    public Node create(Query query) {
        return new CreateQuery(query).execute(this);
    }

    public Node getOrCreate(String name) {
        return this.getOrCreate(Queries.from(name));
    }

    public Node getOrCreate(Query query) {
        return new GetOrCreateQuery(query).execute(this);
    }

    public Node getSingle(String name) {
        return this.getSingle(Queries.from(name));
    }

    public Node getSingle(Query query) {
        return new GetSingleQuery(query).execute(this);
    }

    public List<Node> get(String name) {
        return this.get(Queries.from(name));
    }

    public List<Node> get(Query query) {
        return new GetQuery(query).execute(this);
    }

    public List<Node> remove(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Path must not be null or empty");
        }
        List<Node> found = this.get(name);
        for (Node child : found) {
            this.children.remove(child);
        }
        return found;
    }

    public List<Node> remove(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("Query must not be null");
        }
        List<Node> found = this.get(query);
        for (Node child : found) {
            this.children.remove(child);
        }
        return found;
    }

    public boolean removeSingle(Node child) {
        return this.children.remove(child);
    }

    public Node removeSingle(String name) {
        Node node = this.getSingle(name);
        if (node != null) {
            this.removeSingle(node);
        }
        return node;
    }

    public Node text(Object text) {
        return this.text(String.valueOf(text));
    }

    public Node text(String text) {
        this.text = text;
        return this;
    }

    public String text() {
        return this.text;
    }

    public String textValue(String name) {
        Node n = this.getSingle(name);
        String text = n == null ? null : n.text();
        return text;
    }

    public List<String> textValues(String name) {
        ArrayList<String> result = new ArrayList<String>();
        List<Node> jars = this.get(name);
        for (Node node : jars) {
            String text = node.text();
            if (text == null) continue;
            result.add(text);
        }
        return Collections.unmodifiableList(result);
    }

    public String name() {
        return this.name;
    }

    public Node parent() {
        return this.parent;
    }

    public List<Node> children() {
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
        return Collections.unmodifiableList(this.children);
    }

    public String toString() {
        return "Node[" + this.name + "] " + "children[" + (this.children != null ? this.children.size() : 0) + "] " + (this.attributes != null ? "attributes[" + this.attributes + "] " : "");
    }
}

