/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.api.query;

import org.jboss.shrinkwrap.descriptor.api.query.NodeQuery;
import org.jboss.shrinkwrap.descriptor.api.query.Query;

public class Queries {
    private static final String PATH_SEPARATOR = "/";
    private static final String ATTR_PATH_SEPERATOR = "@";
    private static final String ATTR_SEPERATOR = "&";
    private static final String ATTR_VALUE_SEPERATOR = "=";

    public static Query from(String query) {
        return Queries.buildExpression(query);
    }

    private static Query buildExpression(String exp) {
        String[] paths;
        if (exp == null) {
            throw new IllegalArgumentException("Path must be specified");
        }
        boolean isAbsolute = exp.startsWith(PATH_SEPARATOR);
        Query def = new Query(isAbsolute);
        for (String path : paths = (isAbsolute ? exp.substring(1) : exp).split(PATH_SEPARATOR)) {
            String name = path.indexOf(ATTR_PATH_SEPERATOR) != -1 ? path.substring(0, path.indexOf(ATTR_PATH_SEPERATOR)) : path;
            String attribute = path.indexOf(ATTR_PATH_SEPERATOR) != -1 ? path.substring(path.indexOf(ATTR_PATH_SEPERATOR) + ATTR_PATH_SEPERATOR.length(), path.length()) : null;
            String[] attributes = attribute == null ? new String[]{} : attribute.split(ATTR_SEPERATOR);
            NodeQuery nodeDef = new NodeQuery(name);
            for (String attr : attributes) {
                String[] nameValue = attr.split(ATTR_VALUE_SEPERATOR);
                if (nameValue.length != 2) {
                    throw new IllegalArgumentException("Attribute without name or value found: " + attr + " in expression: " + exp);
                }
                nodeDef.attribute(nameValue[0], nameValue[1]);
            }
            def.addDefinition(nodeDef);
        }
        return def;
    }
}

