/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence;

import org.jboss.shrinkwrap.descriptor.api.Node;

public enum ProviderType {
    HIBERNATE("org.hibernate.ejb.HibernatePersistence"),
    ECLIPSE_LINK("org.eclipse.persistence.jpa.PersistenceProvider");

    private String providerClass;

    private ProviderType(String providerClass) {
        this.providerClass = providerClass;
    }

    public String getProviderClass() {
        return this.providerClass;
    }

    public static ProviderType fromProviderClass(Node providerNode) {
        if (providerNode == null) {
            return null;
        }
        return ProviderType.fromProviderClass(providerNode.text());
    }

    public static ProviderType fromProviderClass(String providerClass) {
        if (providerClass == null) {
            return null;
        }
        for (ProviderType candidate : ProviderType.values()) {
            if (!candidate.getProviderClass().equals(providerClass)) continue;
            return candidate;
        }
        return null;
    }
}

