/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.base;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.jboss.shrinkwrap.descriptor.api.ApiExposition;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImportException;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.Node;

public abstract class DescriptorImporterBase<T extends Descriptor>
implements DescriptorImporter<T> {
    private final Class<T> endUserViewImplType;
    private final String descriptorName;

    public DescriptorImporterBase(Class<T> endUserViewImplType, String descriptorName) throws IllegalArgumentException {
        if (endUserViewImplType == null) {
            throw new IllegalArgumentException("End user view impl type must be specified");
        }
        if (descriptorName == null) {
            throw new IllegalArgumentException("Descriptor name must be specified");
        }
        this.endUserViewImplType = endUserViewImplType;
        this.descriptorName = descriptorName;
    }

    @Override
    public T from(File file) throws IllegalArgumentException, DescriptorImportException {
        if (file == null) {
            throw new IllegalArgumentException("File not specified");
        }
        try {
            return this.from(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Specified file does not exist or is a directory: " + file.getAbsolutePath());
        }
    }

    @Override
    public T from(String string) throws IllegalArgumentException, DescriptorImportException {
        if (string == null) {
            throw new IllegalArgumentException("Input must be specified");
        }
        if (string.trim().length() == 0) {
            return (T)((Descriptor)this.endUserViewImplType.cast(ApiExposition.createFromImplModelType(this.endUserViewImplType, this.descriptorName)));
        }
        return this.from(new ByteArrayInputStream(string.getBytes()));
    }

    @Override
    public T from(InputStream in) throws IllegalArgumentException, DescriptorImportException {
        Descriptor descriptor;
        Constructor<T> constructor;
        if (in == null) {
            throw new IllegalArgumentException("InputStream must be specified");
        }
        Node rootNode = this.importRootNode(in);
        try {
            constructor = this.endUserViewImplType.getConstructor(String.class, Node.class);
        }
        catch (NoSuchMethodException e) {
            throw new DescriptorImportException("Descriptor impl " + this.endUserViewImplType.getName() + " does not have a constructor accepting " + String.class.getName() + " and " + Node.class.getName(), e);
        }
        try {
            descriptor = (Descriptor)constructor.newInstance(this.descriptorName, rootNode);
        }
        catch (Exception e) {
            throw new DescriptorImportException("Could not create new instance using " + constructor + " with arg: " + rootNode);
        }
        return (T)descriptor;
    }

    public abstract Node importRootNode(InputStream var1) throws DescriptorImportException;
}

