/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.base;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExportException;
import org.jboss.shrinkwrap.descriptor.impl.base.Charset;
import org.jboss.shrinkwrap.descriptor.impl.base.DescriptorImplBase;
import org.jboss.shrinkwrap.descriptor.spi.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.spi.NodeProvider;

public abstract class NodeProviderImplBase
extends DescriptorImplBase
implements NodeProvider {
    public NodeProviderImplBase(String name) {
        super(name);
    }

    @Override
    public String exportAsString() throws DescriptorExportException {
        String content;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.exportTo(baos);
        try {
            content = baos.toString(Charset.UTF8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new DescriptorExportException("Inconsistent encoding used during export", e);
        }
        return content;
    }

    @Override
    public void exportTo(OutputStream output) throws DescriptorExportException, IllegalArgumentException {
        if (output == null) {
            throw new IllegalArgumentException("Can not export to null stream");
        }
        this.getExporter().to(this.getRootNode(), output);
    }

    protected abstract DescriptorExporter getExporter();
}

