/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.base;

import java.io.OutputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExportException;
import org.jboss.shrinkwrap.descriptor.api.Node;
import org.jboss.shrinkwrap.descriptor.spi.DescriptorExporter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLExporter
implements DescriptorExporter {
    @Override
    public void to(Node node, OutputStream out) throws DescriptorExportException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document root = builder.newDocument();
            this.writeRecursive(root, node);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(out);
            transformer.transform(new DOMSource(root), result);
        }
        catch (Exception e) {
            throw new DescriptorExportException("Could not export Node strcuture to XML", e);
        }
    }

    private void writeRecursive(org.w3c.dom.Node target, Node source) {
        Document owned = target.getOwnerDocument();
        if (owned == null) {
            owned = (Document)target;
        }
        Element targetChild = null;
        if (source.text() != null) {
            targetChild = owned.createElement(source.name());
            targetChild.appendChild(owned.createTextNode(source.text()));
        } else {
            targetChild = owned.createElement(source.name());
        }
        target.appendChild(targetChild);
        for (Map.Entry<String, String> attribute : source.attributes().entrySet()) {
            Attr attr = owned.createAttribute(attribute.getKey());
            attr.setValue(attribute.getValue());
            targetChild.getAttributes().setNamedItem(attr);
        }
        for (Node sourceChild : source.children()) {
            this.writeRecursive(targetChild, sourceChild);
        }
    }
}

