/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.base;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImportException;
import org.jboss.shrinkwrap.descriptor.api.Node;
import org.jboss.shrinkwrap.descriptor.impl.base.DescriptorImporterBase;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class XMLImporter<T extends Descriptor>
extends DescriptorImporterBase<T> {
    public XMLImporter(Class<T> endUserViewImplType, String descriptorName) {
        super(endUserViewImplType, descriptorName);
    }

    @Override
    public Node importRootNode(InputStream stream) throws DescriptorImportException {
        try {
            if (stream.available() == 0) {
                return null;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            Node root = new Node(doc.getDocumentElement().getNodeName());
            this.readRecursive(root, doc.getDocumentElement());
            return root;
        }
        catch (Exception e) {
            throw new DescriptorImportException("Could not import XML from stream", e);
        }
    }

    private void readRecursive(Node target, org.w3c.dom.Node source) {
        this.readAttributes(target, source);
        NodeList sourceChildren = source.getChildNodes();
        if (sourceChildren != null) {
            for (int i = 0; i < sourceChildren.getLength(); ++i) {
                org.w3c.dom.Node child = sourceChildren.item(i);
                if (child.getNodeType() == 3) continue;
                Node newTarget = target.create(child.getNodeName());
                if (this.onlyTextChildren(child)) {
                    newTarget.text(child.getTextContent());
                    this.readAttributes(newTarget, child);
                    continue;
                }
                this.readRecursive(newTarget, child);
            }
        }
    }

    private void readAttributes(Node target, org.w3c.dom.Node source) {
        NamedNodeMap attributes = source.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                org.w3c.dom.Node attribute = attributes.item(i);
                target.attribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
    }

    private boolean onlyTextChildren(org.w3c.dom.Node source) {
        NodeList children = source.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (child.getNodeType() == 3) continue;
            return false;
        }
        return true;
    }
}

