/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.base.query;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.shrinkwrap.descriptor.api.Node;
import org.jboss.shrinkwrap.descriptor.api.query.NodeQuery;
import org.jboss.shrinkwrap.descriptor.api.query.Query;
import org.jboss.shrinkwrap.descriptor.impl.base.query.AbstractQueryExecuter;
import org.jboss.shrinkwrap.descriptor.impl.base.query.GetSingleQuery;

public class GetOrCreateQuery
extends AbstractQueryExecuter<Node> {
    public GetOrCreateQuery(Query def) {
        super(def);
    }

    @Override
    public Node execute(Node node) {
        Query def = this.getDefinition();
        List<NodeQuery> nodeDefs = def.getDefinitions();
        GetSingleQuery single = new GetSingleQuery(this.getDefinition());
        Node found = single.execute(node);
        if (found == null) {
            int startIndex;
            Node current = def.isAbsolute() ? this.findRoot(node) : node;
            int n = startIndex = def.isAbsolute() ? 1 : 0;
            if (def.isAbsolute() && !nodeDefs.get(0).matches(current)) {
                return null;
            }
            return this.findOrCreateMatch(current, nodeDefs.listIterator(startIndex));
        }
        return found;
    }

    private Node findOrCreateMatch(Node parent, Iterator<NodeQuery> definitions) {
        NodeQuery def;
        NodeQuery nodeQuery = def = definitions.hasNext() ? definitions.next() : null;
        if (def == null) {
            return parent;
        }
        for (Node child : parent.children()) {
            if (!def.matches(child)) continue;
            return this.findOrCreateMatch(child, definitions);
        }
        Node createdNode = new Node(def.name(), parent);
        for (Map.Entry<String, String> attribute : def.attributes().entrySet()) {
            createdNode.attribute(attribute.getKey(), attribute.getValue());
        }
        return this.findOrCreateMatch(createdNode, definitions);
    }
}

