/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.spec.cdi.beans;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.decorator.Decorator;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Stereotype;
import javax.interceptor.Interceptor;
import org.jboss.shrinkwrap.descriptor.api.Node;
import org.jboss.shrinkwrap.descriptor.api.spec.cdi.beans.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.impl.base.NodeProviderImplBase;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLExporter;
import org.jboss.shrinkwrap.descriptor.spi.DescriptorExporter;

public class BeansDescriptorImpl
extends NodeProviderImplBase
implements BeansDescriptor {
    private final Node beans;

    public BeansDescriptorImpl(String descriptorName) {
        this(descriptorName, new Node("beans").attribute("xmlns", "http://java.sun.com/xml/ns/javaee").attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
    }

    public BeansDescriptorImpl(String descriptorName, Node beans) {
        super(descriptorName);
        this.beans = beans;
    }

    @Override
    public BeansDescriptor interceptors(String ... classes) {
        for (String c : classes) {
            this.beans.getOrCreate("interceptors").create("class").text(c);
        }
        return this;
    }

    @Override
    public BeansDescriptor interceptor(String clazz) {
        return this.interceptors(clazz);
    }

    @Override
    public BeansDescriptor decorators(String ... classes) {
        for (String c : classes) {
            this.beans.getOrCreate("decorators").create("class").text(c);
        }
        return this;
    }

    @Override
    public BeansDescriptor decorator(String clazz) {
        return this.decorators(clazz);
    }

    @Override
    public BeansDescriptor alternativeClasses(String ... classes) {
        for (String c : classes) {
            this.beans.getOrCreate("alternatives").create("class").text(c);
        }
        return this;
    }

    @Override
    public BeansDescriptor alternativeClass(String clazz) {
        return this.alternativeClasses(clazz);
    }

    @Override
    public BeansDescriptorImpl alternativeStereotypes(String ... annotations) {
        for (String s : annotations) {
            this.beans.getOrCreate("alternatives").create("stereotype").text(s);
        }
        return this;
    }

    @Override
    public BeansDescriptorImpl alternativeStereotype(String clazz) {
        return this.alternativeStereotypes(clazz);
    }

    @Override
    public BeansDescriptor interceptors(Class<?> ... classes) {
        for (Class<?> c : classes) {
            if (!c.isAnnotationPresent(Interceptor.class)) {
                throw new IllegalArgumentException("Class is not an interceptor");
            }
            this.beans.getOrCreate("interceptors").create("class").text(c.getName());
        }
        return this;
    }

    @Override
    public BeansDescriptor interceptor(Class<?> clazz) {
        return this.interceptors(clazz);
    }

    @Override
    public BeansDescriptor decorators(Class<?> ... classes) {
        for (Class<?> c : classes) {
            if (!c.isAnnotationPresent(Decorator.class)) {
                throw new IllegalArgumentException("Class is not a decorator");
            }
            this.beans.getOrCreate("decorators").create("class").text(c.getName());
        }
        return this;
    }

    @Override
    public BeansDescriptor decorator(Class<?> clazz) {
        return this.decorators(clazz);
    }

    @Override
    public BeansDescriptor alternativeClasses(Class<?> ... classes) {
        for (Class<?> c : classes) {
            if (!c.isAnnotationPresent(Alternative.class)) {
                throw new IllegalArgumentException("Class is not an alternative");
            }
            this.beans.getOrCreate("alternatives").create("class").text(c.getName());
        }
        return this;
    }

    @Override
    public BeansDescriptor alternativeClass(Class<?> clazz) {
        return this.alternativeClasses(clazz);
    }

    @Override
    public BeansDescriptorImpl alternativeStereotypes(Class<? extends Annotation> ... annotations) {
        for (Class<? extends Annotation> a : annotations) {
            if (!a.isAnnotationPresent(Stereotype.class)) {
                throw new IllegalArgumentException("Annotation is not a stereotype");
            }
            if (!a.isAnnotationPresent(Alternative.class)) {
                throw new IllegalArgumentException("Stereotype is not an alternative");
            }
            this.beans.getOrCreate("alternatives").create("stereotype").text(a.getName());
        }
        return this;
    }

    @Override
    public BeansDescriptorImpl alternativeStereotype(Class<? extends Annotation> clazz) {
        return this.alternativeStereotypes(new Class[]{clazz});
    }

    @Override
    public Node getRootNode() {
        return this.beans;
    }

    @Override
    protected DescriptorExporter getExporter() {
        return new XMLExporter();
    }

    @Override
    public List<String> getAlternativeClasses() {
        return this.beans.textValues("alternatives/class");
    }

    @Override
    public List<String> getAlternativeStereotypes() {
        return this.beans.textValues("alternatives/stereotype");
    }

    @Override
    public List<String> getDecorators() {
        return this.beans.textValues("decorators/class");
    }

    @Override
    public List<String> getInterceptors() {
        return this.beans.textValues("interceptors/class");
    }
}

