/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.spec.ee.application;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Node;
import org.jboss.shrinkwrap.descriptor.api.spec.ee.application.ApplicationDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.ee.application.SecurityRole;
import org.jboss.shrinkwrap.descriptor.api.spec.ee.application.WebModule;
import org.jboss.shrinkwrap.descriptor.impl.base.NodeProviderImplBase;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLExporter;
import org.jboss.shrinkwrap.descriptor.impl.spec.ee.application.SecurityRoleImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.ee.application.WebModuleImpl;
import org.jboss.shrinkwrap.descriptor.spi.DescriptorExporter;

public class ApplicationDescriptorImpl
extends NodeProviderImplBase
implements ApplicationDescriptor {
    private final Node model;

    public ApplicationDescriptorImpl(String descriptorName) {
        this(descriptorName, new Node("application").attribute("xmlns", "http://java.sun.com/xml/ns/javaee").attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        this.version("6");
    }

    public ApplicationDescriptorImpl(String descriptorName, Node model) {
        super(descriptorName);
        this.model = model;
    }

    @Override
    public ApplicationDescriptor description(String description) {
        this.model.getOrCreate("description").text(description);
        return this;
    }

    @Override
    public ApplicationDescriptor displayName(String displayName) {
        this.model.getOrCreate("display-name").text(displayName);
        return this;
    }

    @Override
    public ApplicationDescriptor libraryDirectory(String libraryDirectory) {
        this.model.getOrCreate("library-directory").text(libraryDirectory);
        return this;
    }

    @Override
    public ApplicationDescriptor ejbModule(String uri) {
        this.model.create("module").create("ejb").text(uri);
        return this;
    }

    @Override
    public ApplicationDescriptor javaModule(String uri) {
        this.model.create("module").create("java").text(uri);
        return this;
    }

    @Override
    public ApplicationDescriptor connectorModule(String uri) {
        this.model.create("module").create("connector").text(uri);
        return this;
    }

    @Override
    public ApplicationDescriptor webModule(String uri, String contextRoot) {
        Node web = this.model.create("module").create("web");
        web.create("web-uri").text(uri);
        web.create("context-root").text(contextRoot);
        return this;
    }

    @Override
    public ApplicationDescriptor version(String version) {
        this.model.attribute("version", version);
        return this;
    }

    @Override
    public ApplicationDescriptor securityRole(String roleName) {
        return this.securityRole(roleName, null);
    }

    @Override
    public ApplicationDescriptor securityRole(String roleName, String description) {
        Node security = this.model.create("security-role");
        if (roleName != null) {
            security.create("role-name").text(roleName);
        }
        if (description != null) {
            security.create("description").text(description);
        }
        return this;
    }

    @Override
    public Node getRootNode() {
        return this.model;
    }

    @Override
    protected DescriptorExporter getExporter() {
        return new XMLExporter();
    }

    @Override
    public String getVersion() {
        return this.model.attributes().get("version");
    }

    @Override
    public String getDisplayName() {
        return this.model.attributes().get("display-name");
    }

    @Override
    public String getDescription() {
        return this.model.attributes().get("description");
    }

    @Override
    public String getLibraryDirectory() {
        return this.model.attributes().get("library-directory");
    }

    @Override
    public List<WebModule> getWebModules() {
        ArrayList<WebModule> result = new ArrayList<WebModule>();
        List<Node> webModules = this.model.get("module/web");
        for (Node module : webModules) {
            String webUri = module.textValue("web-uri");
            String contextRoot = module.textValue("context-root");
            if (webUri == null && contextRoot == null) continue;
            result.add(new WebModuleImpl(webUri, contextRoot));
        }
        return result;
    }

    @Override
    public List<String> getEjbModules() {
        return this.model.textValues("module/ejb");
    }

    @Override
    public List<String> getJavaModules() {
        return this.model.textValues("module/java");
    }

    @Override
    public List<String> getConnectorModules() {
        return this.model.textValues("module/connector");
    }

    @Override
    public List<SecurityRole> getSecurityRoles() {
        ArrayList<SecurityRole> result = new ArrayList<SecurityRole>();
        List<Node> securityRoles = this.model.get("security-role");
        for (Node module : securityRoles) {
            String name = module.textValue("role-name");
            String desc = module.textValue("description");
            if (name == null && desc == null) continue;
            result.add(new SecurityRoleImpl(name, desc));
        }
        return result;
    }
}

