/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.spec.jpa.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Node;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.PersistenceUnitDef;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.Property;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.ProviderType;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.SchemaGenerationModeType;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.SharedCacheModeType;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.TransactionType;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.ValidationModeType;
import org.jboss.shrinkwrap.descriptor.impl.spec.jpa.persistence.PersistenceDescriptorImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.jpa.persistence.PropertyImpl;

public class PersistenceUnitDefImpl
extends PersistenceDescriptorImpl
implements PersistenceUnitDef {
    private final Node persistenceUnit;

    public PersistenceUnitDefImpl(String descriptorName, Node persistence, Node persistenceUnit) {
        super(descriptorName, persistence);
        this.persistenceUnit = persistenceUnit;
    }

    @Override
    public PersistenceUnitDef name(String name) {
        this.persistenceUnit.attribute("name", name);
        return this;
    }

    @Override
    public PersistenceUnitDef description(String description) {
        this.persistenceUnit.getOrCreate("description").text(description);
        return this;
    }

    @Override
    public PersistenceUnitDef nonJtaDataSource(String jndiName) {
        if (jndiName == null) {
            this.persistenceUnit.remove("non-jta-data-source");
        } else {
            this.persistenceUnit.removeSingle("jta-data-source");
            this.persistenceUnit.getOrCreate("non-jta-data-source").text(jndiName);
        }
        return this;
    }

    @Override
    public PersistenceUnitDef jtaDataSource(String jndiName) {
        if (jndiName == null) {
            this.persistenceUnit.remove("jta-data-source");
        } else {
            this.persistenceUnit.removeSingle("non-jta-data-source");
            this.persistenceUnit.getOrCreate("jta-data-source").text(jndiName);
        }
        return this;
    }

    @Override
    public PersistenceUnitDef transactionType(TransactionType transactionType) {
        this.persistenceUnit.attribute("transaction-type", transactionType.name());
        return this;
    }

    @Override
    public PersistenceUnitDef property(String name, Object value) {
        this.persistenceUnit.getOrCreate("properties").getOrCreate("property@name=" + name).attribute("value", value);
        return this;
    }

    @Override
    public List<Property> getProperties() {
        ArrayList<PropertyImpl> result = new ArrayList<PropertyImpl>();
        Node props = this.persistenceUnit.getSingle("properties");
        if (props != null) {
            for (Node node : props.children()) {
                result.add(new PropertyImpl(node));
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Property removeProperty(String name) {
        Node props = this.persistenceUnit.getSingle("properties");
        for (Node node : props.get("property")) {
            PropertyImpl prop = new PropertyImpl(node);
            if (!prop.getName().equals(name)) continue;
            props.removeSingle(node);
            return new PropertyImpl(node);
        }
        return null;
    }

    @Override
    public boolean removeProperty(Property prop) {
        return this.removeProperty(prop.getName()) != null;
    }

    @Override
    public List<Property> clearProperties() {
        ArrayList<PropertyImpl> result = new ArrayList<PropertyImpl>();
        Node props = this.persistenceUnit.removeSingle("properties");
        for (Node node : props.get("property")) {
            result.add(new PropertyImpl(node));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public PersistenceUnitDef classes(Class<?> ... classes) {
        for (Class<?> c : classes) {
            this.persistenceUnit.create("class").text(c.getName());
        }
        return this;
    }

    @Override
    public PersistenceUnitDef classes(String ... classes) {
        for (String c : classes) {
            this.persistenceUnit.create("class").text(c);
        }
        return this;
    }

    @Override
    public PersistenceUnitDef jarFiles(String ... paths) {
        for (String p : paths) {
            this.persistenceUnit.create("jar-file").text(p);
        }
        return this;
    }

    @Override
    public PersistenceUnitDef jarFile(String path) {
        return this.jarFiles(path);
    }

    @Override
    public PersistenceUnitDef mappingFiles(String ... paths) {
        for (String p : paths) {
            this.persistenceUnit.create("mapping-file").text(p);
        }
        return this;
    }

    @Override
    public PersistenceUnitDef mappingFile(String path) {
        return this.mappingFiles(path);
    }

    @Override
    public PersistenceUnitDef sharedCacheMode(SharedCacheModeType sharedCacheMode) {
        this.persistenceUnit.getOrCreate("shared-cache-mode").text(sharedCacheMode.name());
        return this;
    }

    @Override
    public PersistenceUnitDef validationMode(ValidationModeType validationMode) {
        this.persistenceUnit.getOrCreate("validation-mode").text(validationMode.name());
        return this;
    }

    @Override
    public PersistenceUnitDef excludeUnlistedClasses() {
        this.persistenceUnit.getOrCreate("exclude-unlisted-classes").text("true");
        return this;
    }

    @Override
    public PersistenceUnitDef includeUnlistedClasses() {
        this.persistenceUnit.getOrCreate("exclude-unlisted-classes").text("false");
        return this;
    }

    @Override
    public PersistenceUnitDef provider(ProviderType providerType) {
        return this.provider(providerType.getProviderClass());
    }

    @Override
    public PersistenceUnitDef provider(String provider) {
        this.persistenceUnit.getOrCreate("provider").text(provider);
        return this;
    }

    @Override
    public PersistenceUnitDef showSql() {
        ProviderType providerType = ProviderType.fromProviderClass(this.persistenceUnit.getSingle("provider"));
        if (providerType == null || providerType == ProviderType.HIBERNATE) {
            this.persistenceUnit.getOrCreate("properties").create("property").attribute("name", "hibernate.show_sql").attribute("value", "true");
        }
        if (providerType == null || providerType == ProviderType.ECLIPSE_LINK) {
            this.persistenceUnit.getOrCreate("properties").create("property").attribute("name", "eclipselink.logging.level").attribute("value", "FINE");
        }
        return this;
    }

    @Override
    public PersistenceUnitDef formatSql() {
        ProviderType providerType = ProviderType.fromProviderClass(this.persistenceUnit.getSingle("provider"));
        if (providerType == null || providerType == ProviderType.HIBERNATE) {
            this.persistenceUnit.getOrCreate("properties").create("property").attribute("name", "hibernate.format_sql").attribute("value", "true");
        }
        return this;
    }

    @Override
    public PersistenceUnitDef schemaGenerationMode(SchemaGenerationModeType schemaGenerationMode) {
        String value;
        ProviderType providerType = ProviderType.fromProviderClass(this.persistenceUnit.getSingle("provider"));
        if (providerType == null || providerType == ProviderType.HIBERNATE) {
            value = null;
            if (SchemaGenerationModeType.CREATE.equals((Object)schemaGenerationMode)) {
                value = "create";
            } else if (SchemaGenerationModeType.CREATE_DROP.equals((Object)schemaGenerationMode)) {
                value = "create-drop";
            } else if (SchemaGenerationModeType.UPDATE.equals((Object)schemaGenerationMode)) {
                value = "update";
            } else if (SchemaGenerationModeType.NONE.equals((Object)schemaGenerationMode)) {
                value = "none";
            }
            if (value != null) {
                this.persistenceUnit.getOrCreate("properties").create("property").attribute("name", "hibernate.hbm2ddl.auto").attribute("value", value);
            }
        }
        if (providerType == null || providerType == ProviderType.ECLIPSE_LINK) {
            value = null;
            if (SchemaGenerationModeType.CREATE.equals((Object)schemaGenerationMode)) {
                value = "create-tables";
            } else if (SchemaGenerationModeType.CREATE_DROP.equals((Object)schemaGenerationMode)) {
                value = "drop-and-create-tables";
            } else {
                if (SchemaGenerationModeType.UPDATE.equals((Object)schemaGenerationMode)) {
                    throw new UnsupportedOperationException((Object)((Object)SchemaGenerationModeType.UPDATE) + " not supported by provider " + (Object)((Object)ProviderType.ECLIPSE_LINK));
                }
                if (SchemaGenerationModeType.NONE.equals((Object)schemaGenerationMode)) {
                    value = "none";
                }
            }
            if (value != null) {
                this.persistenceUnit.getOrCreate("properties").create("property").attribute("name", "eclipselink.ddl-generation").attribute("value", value);
            }
        }
        return this;
    }

    @Override
    public String getName() {
        return this.persistenceUnit.attributes().get("name");
    }

    @Override
    public String getDescription() {
        return this.persistenceUnit.attributes().get("description");
    }

    @Override
    public String getNonJtaDataSource() {
        return this.persistenceUnit.attributes().get("non-jta-data-source");
    }

    @Override
    public String getTransactionType() {
        return this.persistenceUnit.attributes().get("transaction-type");
    }

    @Override
    public String getJtaDataSource() {
        return this.persistenceUnit.attributes().get("jta-data-source");
    }

    @Override
    public List<String> getJarFiles() {
        return this.persistenceUnit.textValues("jar-file");
    }

    @Override
    public List<String> getClasses() {
        return this.persistenceUnit.textValues("class");
    }

    @Override
    public List<String> getMappingFiles() {
        return this.persistenceUnit.textValues("mapping-file");
    }

    @Override
    public SharedCacheModeType getSharedCacheMode() {
        Node mode = this.persistenceUnit.getSingle("shared-cache-mode");
        return mode == null ? null : SharedCacheModeType.valueOf(mode.text());
    }

    @Override
    public ValidationModeType getValidationMode() {
        Node mode = this.persistenceUnit.getSingle("validation-mode");
        return mode == null ? null : ValidationModeType.valueOf(mode.text());
    }

    @Override
    public boolean includesUnlistedClasses() {
        Node mode = this.persistenceUnit.getSingle("exclude-unlisted-classes");
        return mode == null ? false : Boolean.valueOf(mode.text());
    }

    @Override
    public String getProvider() {
        Node provider = this.persistenceUnit.getSingle("provider");
        return provider == null ? null : provider.text();
    }
}

