/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.shrinkwrap.descriptor.api.Node;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.ServletDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.ServletMappingDef;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.InitParamDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.ServletMappingDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.WebAppDescriptorImpl;

public class ServletDefImpl
extends WebAppDescriptorImpl
implements ServletDef {
    private final Node servlet;

    public ServletDefImpl(String descriptorName, Node webApp, Node servlet) {
        super(descriptorName, webApp);
        this.servlet = servlet;
    }

    @Override
    public ServletDef name(String name) {
        this.servlet.getOrCreate("servlet-name").text(name);
        return this;
    }

    @Override
    public ServletDef asyncSupported(boolean value) {
        this.servlet.getOrCreate("async-supported").text(value);
        return this;
    }

    @Override
    public ServletDef initParam(String name, Object value) {
        InitParamDefImpl param = new InitParamDefImpl(this.getDescriptorName(), this.getRootNode(), this.servlet);
        param.initParam(name, value == null ? null : value.toString());
        return this;
    }

    @Override
    public ServletDef loadOnStartup(int order) {
        this.servlet.getOrCreate("load-on-startup").text(order);
        return this;
    }

    @Override
    public ServletMappingDef mapping() {
        Node mappingNode = this.getRootNode().create("servlet-mapping");
        ServletMappingDefImpl mapping = new ServletMappingDefImpl(this.getDescriptorName(), this.getRootNode(), this.servlet, mappingNode);
        mapping.servletName(this.getName());
        return mapping;
    }

    @Override
    public ServletDef servletClass(Class<?> clazz) {
        return this.servletClass(clazz.getName());
    }

    @Override
    public ServletDef servletClass(String clazz) {
        this.servlet.getOrCreate("servlet-class").text(clazz);
        return this;
    }

    @Override
    public String getName() {
        return this.servlet.textValue("servlet-name");
    }

    @Override
    public String getInitParam(String name) {
        Map<String, String> params = this.getInitParams();
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (e.getKey() == null || !e.getKey().equals(name)) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public Map<String, String> getInitParams() {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Node> params = this.servlet.get("init-param");
        for (Node node : params) {
            result.put(node.textValue("param-name"), node.textValue("param-value"));
        }
        return result;
    }

    @Override
    public boolean isAsyncSupported() {
        return Strings.isTrue(this.servlet.textValue("async-supported"));
    }

    @Override
    public int getLoadOnStartup() throws NumberFormatException {
        String tex = this.servlet.textValue("load-on-startup");
        return tex == null ? null : Integer.valueOf(tex);
    }

    @Override
    public List<ServletMappingDef> getMappings() {
        ArrayList<ServletMappingDef> result = new ArrayList<ServletMappingDef>();
        List<ServletMappingDef> mappings = this.getServletMappings();
        for (ServletMappingDef mapping : mappings) {
            if (!Strings.areEqualTrimmed(this.getName(), mapping.getServletName())) continue;
            result.add(mapping);
        }
        return result;
    }
}

