/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.webapp.FacesServlet;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.jboss.shrinkwrap.descriptor.api.Node;
import org.jboss.shrinkwrap.descriptor.api.spec.ee.application.SecurityRole;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.AuthMethodType;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.CookieConfigDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.ErrorPage;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.FacesProjectStage;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.FacesStateSavingMethod;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.FilterDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.FilterMappingDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.LoginConfig;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.SecurityConstraintDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.ServletDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.ServletMappingDef;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.TrackingModeType;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.impl.base.NodeProviderImplBase;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLExporter;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.CookieConfigDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.FilterDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.FilterMappingDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.SecurityConstraintDefImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.ServletDefImpl;
import org.jboss.shrinkwrap.descriptor.spi.DescriptorExporter;

public class WebAppDescriptorImpl
extends NodeProviderImplBase
implements WebAppDescriptor {
    private static final String NODE_NAME_FILTER = "filter";
    private static final String NODE_NAME_FILTER_MAPPINGS = "filter-mapping";
    private static final String NODE_NAME_FILTER_NAME = "filter-name";
    private final Node model;

    public WebAppDescriptorImpl(String descriptorName) {
        this(descriptorName, new Node("web-app").attribute("xmlns", "http://java.sun.com/xml/ns/javaee").attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").attribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd"));
        this.version("3.0");
    }

    public WebAppDescriptorImpl(String descriptorName, Node model) {
        super(descriptorName);
        this.model = model;
    }

    @Override
    public WebAppDescriptor version(String version) {
        if (version == null || version.length() == 0) {
            throw new IllegalArgumentException("Version must be specified");
        }
        this.model.attribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_" + version.replace(".", "_") + ".xsd");
        this.model.attribute("version", version);
        return this;
    }

    @Override
    public WebAppDescriptor metadataComplete(boolean value) {
        this.model.attribute("metadata-complete", value);
        return this;
    }

    @Override
    public WebAppDescriptor moduleName(String name) {
        this.model.getOrCreate("module-name").text(name);
        return this;
    }

    @Override
    public WebAppDescriptor description(String description) {
        this.model.create("description").text(description);
        return this;
    }

    @Override
    public WebAppDescriptor displayName(String displayName) {
        this.model.getOrCreate("display-name").text(displayName);
        return this;
    }

    @Override
    public WebAppDescriptor distributable() {
        this.model.getOrCreate("distributable");
        return this;
    }

    @Override
    public WebAppDescriptor contextParam(String name, Object value) {
        Node context = this.model.create("context-param");
        context.create("param-name").text(name);
        context.create("param-value").text(value);
        return this;
    }

    @Override
    public WebAppDescriptor facesProjectStage(FacesProjectStage stage) {
        return this.contextParam("javax.faces.PROJECT_STAGE", stage.name());
    }

    @Override
    public WebAppDescriptor facesStateSavingMethod(FacesStateSavingMethod method) {
        return this.contextParam("javax.faces.STATE_SAVING_METHOD", method.name());
    }

    @Override
    public WebAppDescriptor facesConfigFiles(String ... paths) {
        if (paths == null || paths.length == 0) {
            return this;
        }
        return this.contextParam("javax.faces.CONFIG_FILES", Strings.join(Arrays.asList(paths), ","));
    }

    @Override
    public WebAppDescriptor listener(Class<? extends EventListener> clazz) {
        return this.listener(clazz.getName());
    }

    @Override
    public WebAppDescriptor listener(String clazz) {
        this.model.create("listener").create("listener-class").text(clazz);
        return this;
    }

    @Override
    public List<FilterDef> getFilters() {
        ArrayList<FilterDef> filters = new ArrayList<FilterDef>();
        for (Node filterNode : this.model.get(NODE_NAME_FILTER)) {
            FilterDefImpl filter = new FilterDefImpl(this.getDescriptorName(), this.model, filterNode);
            filters.add(filter);
        }
        return filters;
    }

    @Override
    public List<FilterMappingDef> getFilterMappings() {
        ArrayList<FilterMappingDef> mappings = new ArrayList<FilterMappingDef>();
        for (Node mappingNode : this.model.get(NODE_NAME_FILTER_MAPPINGS)) {
            String filterName = mappingNode.getSingle(NODE_NAME_FILTER_NAME).text();
            FilterDef filterDef = null;
            List<FilterDef> filters = this.getFilters();
            for (FilterDef filter : filters) {
                if (!Strings.areEqualTrimmed(filter.getName(), filterName)) continue;
                filterDef = filter;
            }
            FilterMappingDefImpl filterMapping = new FilterMappingDefImpl(this.getDescriptorName(), this.getRootNode(), ((FilterDefImpl)filterDef).getNode(), mappingNode);
            mappings.add(filterMapping);
        }
        return mappings;
    }

    @Override
    public FilterDef filter(Class<? extends Filter> clazz, String ... urlPatterns) {
        return this.filter(clazz.getSimpleName(), clazz.getName(), urlPatterns);
    }

    @Override
    public FilterDef filter(String clazz, String ... urlPatterns) {
        return this.filter(this.getSimpleName(clazz), clazz, urlPatterns);
    }

    @Override
    public FilterDef filter(String name, Class<? extends Filter> clazz, String[] urlPatterns) {
        return this.filter(name, clazz.getName(), urlPatterns);
    }

    @Override
    public FilterDef filter(String name, String clazz, String[] urlPatterns) {
        Node filter = this.model.create(NODE_NAME_FILTER);
        filter.create(NODE_NAME_FILTER_NAME).text(name);
        filter.create("filter-class").text(clazz);
        FilterMappingDef f = new FilterDefImpl(this.getDescriptorName(), this.model, filter).mapping().urlPatterns(urlPatterns);
        return f;
    }

    @Override
    public ServletDef servlet(Class<? extends Servlet> clazz, String ... urlPatterns) {
        return this.servlet(clazz.getSimpleName(), clazz.getName(), urlPatterns);
    }

    @Override
    public ServletDef servlet(String clazz, String ... urlPatterns) {
        return this.servlet(this.getSimpleName(clazz), clazz, urlPatterns);
    }

    @Override
    public ServletDef servlet(String name, Class<? extends Servlet> clazz, String[] urlPatterns) {
        return this.servlet(name, clazz.getName(), urlPatterns);
    }

    @Override
    public ServletDef servlet(String name, String clazz, String[] urlPatterns) {
        Node servletNode = this.model.create("servlet");
        servletNode.create("servlet-name").text(name);
        servletNode.create("servlet-class").text(clazz);
        ServletDefImpl servlet = new ServletDefImpl(this.getDescriptorName(), this.model, servletNode);
        servlet.mapping().urlPatterns(urlPatterns);
        return servlet;
    }

    @Override
    public WebAppDescriptor facesServlet() {
        this.servlet(FacesServlet.class, "*.jsf");
        return this;
    }

    @Override
    public WebAppDescriptor welcomeFiles(String ... servletPaths) {
        for (String p : servletPaths) {
            this.model.getOrCreate("welcome-file-list").create("welcome-file").text(p);
        }
        return this;
    }

    @Override
    public WebAppDescriptor welcomeFile(String servletPath) {
        return this.welcomeFiles(servletPath);
    }

    @Override
    public WebAppDescriptor sessionTimeout(int timeout) {
        this.model.getOrCreate("session-config").getOrCreate("session-timeout").text(timeout);
        return this;
    }

    @Override
    public WebAppDescriptor sessionTrackingModes(TrackingModeType ... sessionTrackingModes) {
        for (TrackingModeType m : sessionTrackingModes) {
            this.model.getOrCreate("session-config").create("tracking-mode").text(m.name());
        }
        return this;
    }

    @Override
    public CookieConfigDef sessionCookieConfig() {
        return new CookieConfigDefImpl(this.getDescriptorName(), this.model);
    }

    @Override
    public WebAppDescriptor errorPage(int errorCode, String location) {
        Node error = this.model.create("error-page");
        error.create("error-code").text(errorCode);
        error.create("location").text(location);
        return this;
    }

    @Override
    public WebAppDescriptor errorPage(String exceptionClass, String location) {
        Node error = this.model.create("error-page");
        error.create("exception-type").text(exceptionClass);
        error.create("location").text(location);
        return this;
    }

    @Override
    public WebAppDescriptor errorPage(Class<? extends Throwable> exceptionClass, String location) {
        return this.errorPage(exceptionClass.getName(), location);
    }

    @Override
    public WebAppDescriptor loginConfig(AuthMethodType authMethod, String realmName) {
        return this.loginConfig(authMethod.toString(), realmName);
    }

    @Override
    public WebAppDescriptor loginConfig(String authMethod, String realmName) {
        Node login = this.model.create("login-config");
        login.create("auth-method").text(authMethod);
        login.create("realm-name").text(realmName);
        return this;
    }

    @Override
    public WebAppDescriptor formLoginConfig(String loginPage, String errorPage) {
        Node login = this.model.create("login-config");
        login.create("auth-method").text((Object)AuthMethodType.FORM);
        Node form = this.model.create("form-login-config");
        form.create("form-login-page").text(loginPage);
        form.create("form-error-page").text(errorPage);
        return this;
    }

    @Override
    public SecurityConstraintDef securityConstraint() {
        return this.securityConstraint(null);
    }

    @Override
    public SecurityConstraintDef securityConstraint(String displayName) {
        Node security = this.model.create("security-constraint");
        if (displayName != null) {
            security.create("name").text(displayName);
        }
        return new SecurityConstraintDefImpl(this.getDescriptorName(), this.model, security);
    }

    @Override
    public WebAppDescriptor securityRole(String roleName) {
        return this.securityRole(roleName, null);
    }

    @Override
    public WebAppDescriptor securityRole(String roleName, String description) {
        Node security = this.model.create("security-role");
        if (roleName != null) {
            security.create("role-name").text(roleName);
        }
        if (description != null) {
            security.create("description").text(description);
        }
        return this;
    }

    @Override
    public WebAppDescriptor absoluteOrdering(String ... names) {
        return this.absoluteOrdering(false, names);
    }

    @Override
    public WebAppDescriptor absoluteOrdering(boolean others, String ... names) {
        Node ordering = this.model.getOrCreate("absolute-ordering");
        if (names != null) {
            for (String name : names) {
                ordering.create("name").text(name);
            }
        }
        if (others) {
            ordering.getOrCreate("others");
        }
        return this;
    }

    @Override
    public Node getRootNode() {
        return this.model;
    }

    @Override
    protected DescriptorExporter getExporter() {
        return new XMLExporter();
    }

    private String getSimpleName(String fqcn) {
        if (fqcn.indexOf(46) >= 0) {
            return fqcn.substring(fqcn.lastIndexOf(46) + 1);
        }
        return fqcn;
    }

    @Override
    public String getVersion() {
        return this.model.attributes().get("version");
    }

    @Override
    public String getModuleName() {
        return this.model.attributes().get("module-name");
    }

    @Override
    public String getDescription() {
        return this.model.attributes().get("description");
    }

    @Override
    public String getDisplayName() {
        return this.model.attributes().get("display-name");
    }

    @Override
    public boolean isDistributable() {
        return this.model.attributes().get("distributable") != null;
    }

    @Override
    public boolean isMetadataComplete() {
        String complete = this.model.attributes().get("metadata-complete");
        if (complete == null) {
            complete = "";
        }
        return "true".equalsIgnoreCase(complete);
    }

    @Override
    public String getContextParam(String name) {
        Map<String, String> params = this.getContextParams();
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (e.getKey() == null || !e.getKey().equals(name)) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public Map<String, String> getContextParams() {
        HashMap<String, String> result = new HashMap<String, String>();
        List<Node> params = this.model.get("context-param");
        for (Node p : params) {
            String name = p.textValue("param-name");
            String value = p.textValue("param-value");
            result.put(name, value);
        }
        return result;
    }

    @Override
    public FacesProjectStage getFacesProjectStage() {
        return FacesProjectStage.valueOf(this.getContextParam("javax.faces.PROJECT_STAGE"));
    }

    @Override
    public FacesStateSavingMethod getFacesStateSavingMethod() {
        return FacesStateSavingMethod.valueOf(this.getContextParam("javax.faces.STATE_SAVING_METHOD"));
    }

    @Override
    public List<String> getFacesConfigFiles() {
        String value = this.getContextParam("javax.faces.CONFIG_FILES");
        return value == null ? new ArrayList() : Arrays.asList(value.split(","));
    }

    @Override
    public List<String> getListeners() {
        return this.model.textValues("listener/listener-class");
    }

    @Override
    public List<ServletDef> getServlets() {
        return null;
    }

    @Override
    public List<ServletMappingDef> getServletMappings() {
        return null;
    }

    @Override
    public boolean hasFacesServlet() {
        return false;
    }

    @Override
    public List<String> getWelcomeFiles() {
        return null;
    }

    @Override
    public int getSessionTimeout() {
        return 0;
    }

    @Override
    public List<TrackingModeType> getSessionTrackingModes() {
        return null;
    }

    @Override
    public List<ErrorPage> getErrorPages() {
        return null;
    }

    @Override
    public List<LoginConfig> getLoginConfigs() {
        return null;
    }

    @Override
    public List<SecurityConstraintDef> getSecurityConstraints() {
        return null;
    }

    @Override
    public List<SecurityRole> getSecurityRoles() {
        return null;
    }
}

