/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.api;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.Properties;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorConstructionInfo;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.GetTcclAction;

class DescriptorInstantiator {
    private static final String MAPPING_LOCATION = "META-INF/services/";
    private static final String KEY_IMPL_CLASS_NAME = "implClass";
    private static final String KEY_DEFAULT_NAME = "defaultName";
    private static final String KEY_IMPORTER_CLASS_NAME = "importerClass";

    private DescriptorInstantiator() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    static <T extends Descriptor> T createFromUserView(Class<T> userViewClass, String descriptorName) throws IllegalArgumentException {
        DescriptorConstructionInfo info = DescriptorInstantiator.getDescriptorConstructionInfoForUserView(userViewClass);
        Class<?> implClass = info.implClass;
        String name = info.defaultName;
        if (descriptorName != null) {
            name = descriptorName;
        }
        Descriptor descriptor = DescriptorInstantiator.createFromImplModelType(implClass, name);
        return (T)((Descriptor)userViewClass.cast(descriptor));
    }

    static Descriptor createFromImplModelType(Class<? extends Descriptor> implClass, String descriptorName) throws IllegalArgumentException {
        Descriptor descriptor;
        Constructor<? extends Descriptor> ctor;
        if (implClass == null) {
            throw new IllegalArgumentException("implClass must be specified");
        }
        if (descriptorName == null || descriptorName.length() == 0) {
            throw new IllegalArgumentException("descriptorName must be specified");
        }
        try {
            ctor = implClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(implClass + " must contain a constructor with a single String argument");
        }
        try {
            descriptor = ctor.newInstance(descriptorName);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new descriptor instance", e);
        }
        return descriptor;
    }

    static <T extends Descriptor> DescriptorImporter<T> createImporterFromUserView(Class<T> userViewClass, String descriptorName) throws IllegalArgumentException {
        DescriptorImporter<?> importer;
        DescriptorConstructionInfo info = DescriptorInstantiator.getDescriptorConstructionInfoForUserView(userViewClass);
        Class<?> implClass = info.implClass;
        if (!userViewClass.isAssignableFrom(implClass)) {
            throw new RuntimeException("Configured implementation class for " + userViewClass.getName() + " is not assignable: " + implClass.getName());
        }
        Class<?> implClassCasted = implClass;
        String name = info.defaultName;
        if (descriptorName != null) {
            name = descriptorName;
        }
        try {
            importer = info.importerClass.getConstructor(Class.class, String.class).newInstance(implClassCasted, name);
        }
        catch (Exception e) {
            throw new RuntimeException("Configured importer for " + userViewClass.getName() + " of type: " + info.importerClass + " could not be created", e);
        }
        return importer;
    }

    private static DescriptorConstructionInfo getDescriptorConstructionInfoForUserView(Class<?> userViewClass) throws IllegalArgumentException {
        if (userViewClass == null) {
            throw new IllegalArgumentException("User view class must be specified");
        }
        String className = userViewClass.getName();
        String resourceName = MAPPING_LOCATION + className;
        ClassLoader tccl = AccessController.doPrivileged(GetTcclAction.INSTANCE);
        InputStream resourceStream = tccl.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            throw new IllegalArgumentException("No resource " + resourceName + " was found configured for user view class " + userViewClass.getName());
        }
        Properties props = new Properties();
        try {
            props.load(resourceStream);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O Problem in reading the properties for " + userViewClass.getName(), e);
        }
        String implClassName = props.getProperty(KEY_IMPL_CLASS_NAME);
        if (implClassName == null || implClassName.length() == 0) {
            throw new IllegalStateException("Resource " + resourceName + " for " + userViewClass + " does not contain key " + KEY_IMPL_CLASS_NAME);
        }
        String importerClassName = props.getProperty(KEY_IMPORTER_CLASS_NAME);
        if (importerClassName == null || importerClassName.length() == 0) {
            throw new IllegalStateException("Resource " + resourceName + " for " + userViewClass + " does not contain key " + KEY_IMPORTER_CLASS_NAME);
        }
        String defaultName = props.getProperty(KEY_DEFAULT_NAME);
        if (defaultName == null) {
            throw new IllegalStateException("Resource " + resourceName + " for " + userViewClass + " does not contain key " + KEY_DEFAULT_NAME);
        }
        DescriptorConstructionInfo info = new DescriptorConstructionInfo(implClassName, importerClassName, defaultName);
        return info;
    }
}

