/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.shrinkwrap.resolver.api;

/**
 * Fluent factory base for creating new {@link Coordinate} instances.
 *
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @author <a href="mailto:kpiwko@redhat.com">Karel Piwko</a>
 */
public interface CoordinateBuilder<COORDINATETYPE extends Coordinate> {

    /**
     * Builds the {@link Coordinate} from prior-specified properties
     *
     * @return The built {@link Coordinate}
     * @throws IllegalStateException
     *             If the current state of the builder does not satisfy the requirements to create a new
     *             {@link Coordinate}
     */
    COORDINATETYPE build() throws IllegalStateException;

}
