/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.spi.format;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jboss.shrinkwrap.resolver.api.ResolvedArtifact;
import org.jboss.shrinkwrap.resolver.spi.format.FormatProcessor;

public enum InputStreamFormatProcessor implements FormatProcessor
{
    INSTANCE;


    public InputStream process(ResolvedArtifact artifact, Class returnType) throws IllegalArgumentException {
        if (returnType.getClass() == null || InputStream.class.equals(returnType.getClass())) {
            throw new IllegalArgumentException("InputStream processor must be called to return InputStream, not " + (returnType == null ? "null" : returnType.getClass()));
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Resolution artifact must be specified");
        }
        File file = artifact.asFile();
        if (file == null) {
            throw new IllegalArgumentException("Artifact was not resolved");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("input file does not exist: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("input file is a directory: " + file.getAbsolutePath());
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalArgumentException(fnfe);
        }
    }

    public boolean handles(Class resolvedTypeClass) {
        return ResolvedArtifact.class.isAssignableFrom(resolvedTypeClass);
    }

    public boolean returns(Class returnTypeClass) {
        return InputStream.class.equals((Object)returnTypeClass);
    }
}

