/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.spi.format;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.shrinkwrap.resolver.api.ResolvedArtifact;
import org.jboss.shrinkwrap.resolver.spi.format.FormatProcessor;

public enum URLFormatProcessor implements FormatProcessor
{
    INSTANCE;


    public URL process(ResolvedArtifact artifact, Class returnType) throws IllegalArgumentException {
        if (returnType.getClass() == null || URL.class.equals(returnType.getClass())) {
            throw new IllegalArgumentException("URL processor must be called to return URL, not " + (returnType == null ? "null" : returnType.getClass()));
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Resolution artifact must be specified");
        }
        File file = artifact.asFile();
        if (file == null) {
            throw new IllegalArgumentException("Artifact was not resolved");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("input file does not exist: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("input file is a directory: " + file.getAbsolutePath());
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean handles(Class resolvedTypeClass) {
        return ResolvedArtifact.class.isAssignableFrom(resolvedTypeClass);
    }

    public boolean returns(Class returnTypeClass) {
        return URL.class.equals((Object)returnTypeClass);
    }
}

