/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import java.util.logging.Level;
import java.util.logging.Logger;

class ClassLoaderSearchUtil {
    private static final Logger log = Logger.getLogger(ClassLoaderSearchUtil.class.getName());

    private ClassLoaderSearchUtil() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    static Class<?> findClassFromClassLoaders(String className, Iterable<ClassLoader> classLoaders) throws ClassNotFoundException, IllegalArgumentException {
        assert (className != null && !className.isEmpty()) : "Class Name must be specified";
        assert (classLoaders != null) : "ClassLoaders as search path must be specified";
        Class<?> clazz = null;
        for (ClassLoader cl : classLoaders) {
            try {
                clazz = Class.forName(className, false, cl);
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("Found requested class " + clazz.getName() + " from ClassLoader " + clazz.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Could not find requested class \"" + className + "\" in any of the associated ClassLoaders: " + classLoaders);
        }
        return clazz;
    }
}

