/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.util.TreeSet;
import javax.security.jacc.URLPatternSpec;
import javax.security.jacc.WebResourcePermission;
import javax.servlet.http.HttpServletRequest;

public final class WebUserDataPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};
    private transient URLPatternSpec urlSpec;
    private transient String httpMethodsString;
    private transient String transportType;
    private transient TreeSet<String> httpMethods;
    private transient TreeSet<String> httpExceptionList;
    private transient String httpExceptionString;

    public WebUserDataPermission(HttpServletRequest request) {
        this(WebResourcePermission.requestURI(request), WebUserDataPermission.requestActions(request));
    }

    public WebUserDataPermission(String name, String actions2) {
        super(name == null ? "/" : name);
        if (name == null) {
            name = "/";
        }
        this.urlSpec = new URLPatternSpec(name);
        this.parseActions(actions2);
    }

    public WebUserDataPermission(String urlPatternSpec, String[] httpMethods, String transportType) {
        super(urlPatternSpec);
        this.urlSpec = new URLPatternSpec(urlPatternSpec);
        Object[] methodInfo = WebResourcePermission.canonicalMethods(httpMethods);
        this.httpMethods = (TreeSet)methodInfo[0];
        this.httpMethodsString = (String)methodInfo[1];
        if (transportType != null && transportType.equalsIgnoreCase("NONE")) {
            transportType = null;
        }
        this.transportType = transportType;
    }

    @Override
    public boolean equals(Object p) {
        if (p == null || !(p instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission perm = (WebUserDataPermission)p;
        return this.implies(perm) && perm.implies(this);
    }

    @Override
    public String getActions() {
        String actions2 = null;
        if (this.httpMethodsString != null) {
            actions2 = this.transportType != null ? this.httpMethodsString + ":" + this.transportType : this.httpMethodsString;
        } else if (this.transportType != null) {
            actions2 = ":" + this.transportType;
        }
        return actions2;
    }

    @Override
    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.urlSpec.hashCode();
        if (this.httpMethods != null) {
            hashCode = 37 * hashCode + this.httpMethods.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean implies(Permission p) {
        if (p == null || !(p instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission perm = (WebUserDataPermission)p;
        boolean implies = this.urlSpec.implies(perm.urlSpec);
        if (implies) {
            if (this.httpExceptionList != null) {
                implies = WebResourcePermission.matchExceptionList(this.httpExceptionList, perm.httpExceptionList);
            }
            if (this.httpMethods != null && perm.httpMethods != null) {
                implies = this.httpMethods.containsAll(perm.httpMethods);
            }
            if (implies && this.transportType != null) {
                implies = this.transportType.equals(perm.transportType);
            }
        }
        return implies;
    }

    private static String requestActions(HttpServletRequest request) {
        String actions2 = request.getMethod() + (request.isSecure() ? ":CONFIDENTIAL" : "");
        return actions2;
    }

    private void parseActions(String actions2) {
        int colon;
        if (actions2 != null && (colon = actions2.indexOf(58)) >= 0) {
            this.transportType = actions2.substring(colon + 1);
            if (this.transportType.equalsIgnoreCase("NONE")) {
                this.transportType = null;
            }
            actions2 = actions2.substring(0, colon);
        }
        boolean exceptionListNeeded = actions2 != null && actions2.startsWith("!");
        Object[] methodInfo = WebResourcePermission.canonicalMethods(actions2);
        if (exceptionListNeeded) {
            this.httpExceptionList = (TreeSet)methodInfo[0];
            this.httpExceptionString = (String)methodInfo[1];
        } else {
            this.httpMethods = (TreeSet)methodInfo[0];
            this.httpMethodsString = (String)methodInfo[1];
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        String actions2 = (String)fields.get("actions", null);
        this.parseActions(actions2);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        fields.put("actions", this.getActions());
        oos.writeFields();
    }
}

