/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.DefaultBeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategy;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;

public abstract class AbstractDiscoveryStrategy
implements DiscoveryStrategy {
    protected final ResourceLoader resourceLoader;
    protected final Bootstrap bootstrap;
    protected final Set<Class<? extends Annotation>> initialBeanDefiningAnnotations;
    protected BeanArchiveScanner scanner;
    private final List<BeanArchiveHandler> handlers;

    public AbstractDiscoveryStrategy(ResourceLoader resourceLoader, Bootstrap bootstrap, Set<Class<? extends Annotation>> initialBeanDefiningAnnotations) {
        this.resourceLoader = resourceLoader;
        this.bootstrap = bootstrap;
        this.handlers = new LinkedList<BeanArchiveHandler>();
        this.initialBeanDefiningAnnotations = initialBeanDefiningAnnotations;
    }

    @Override
    public void setScanner(BeanArchiveScanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public Set<WeldBeanDeploymentArchive> performDiscovery() {
        if (this.scanner == null) {
            this.scanner = new DefaultBeanArchiveScanner(this.resourceLoader, this.bootstrap);
        }
        ArrayList<BeanArchiveBuilder> beanArchiveBuilders = new ArrayList<BeanArchiveBuilder>();
        HashSet<String> processedRefs = new HashSet<String>();
        for (BeanArchiveScanner.ScanResult scanResult : this.scanner.scan().values()) {
            String ref = scanResult.getBeanArchiveRef();
            if (processedRefs.contains(ref)) {
                throw CommonLogger.LOG.invalidScanningResult(ref);
            }
            CommonLogger.LOG.processingBeanArchiveReference(ref);
            processedRefs.add(ref);
            BeanArchiveBuilder builder = null;
            for (BeanArchiveHandler handler : this.handlers) {
                builder = handler.handle(ref);
                if (builder == null) continue;
                builder.setId(scanResult.getBeanArchiveId());
                builder.setBeansXml(scanResult.getBeansXml());
                beanArchiveBuilders.add(builder);
                break;
            }
            if (builder != null) continue;
            CommonLogger.LOG.beanArchiveReferenceCannotBeHandled(ref, this.handlers);
        }
        this.beforeDiscovery(beanArchiveBuilders);
        HashSet<WeldBeanDeploymentArchive> archives = new HashSet<WeldBeanDeploymentArchive>();
        block7: for (BeanArchiveBuilder builder : beanArchiveBuilders) {
            BeansXml beansXml = builder.getBeansXml();
            switch (beansXml.getBeanDiscoveryMode()) {
                case ALL: {
                    this.addToArchives(archives, this.processAllDiscovery(builder));
                    continue block7;
                }
                case ANNOTATED: {
                    this.addToArchives(archives, this.processAnnotatedDiscovery(builder));
                    continue block7;
                }
                case NONE: {
                    this.addToArchives(archives, this.processNoneDiscovery(builder));
                    continue block7;
                }
            }
            CommonLogger.LOG.undefinedBeanDiscoveryValue(beansXml.getBeanDiscoveryMode());
        }
        for (WeldBeanDeploymentArchive archive : archives) {
            archive.getServices().add(ResourceLoader.class, (Service)this.resourceLoader);
        }
        this.afterDiscovery(archives);
        return archives;
    }

    @Override
    public ClassFileServices getClassFileServices() {
        return null;
    }

    protected void addToArchives(Set<WeldBeanDeploymentArchive> deploymentArchives, WeldBeanDeploymentArchive bda) {
        if (bda != null) {
            deploymentArchives.add(bda);
        }
    }

    protected void beforeDiscovery(Collection<BeanArchiveBuilder> builders) {
    }

    protected void afterDiscovery(Set<WeldBeanDeploymentArchive> archives) {
    }

    protected WeldBeanDeploymentArchive processNoneDiscovery(BeanArchiveBuilder builder) {
        return null;
    }

    protected WeldBeanDeploymentArchive processAnnotatedDiscovery(BeanArchiveBuilder builder) {
        throw new UnsupportedOperationException();
    }

    protected WeldBeanDeploymentArchive processAllDiscovery(BeanArchiveBuilder builder) {
        return builder.build();
    }

    @Override
    public void registerHandler(BeanArchiveHandler handler) {
        this.handlers.add(handler);
    }
}

