/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.BeanAttributes;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerMethod<X, T>
extends AbstractProducerBean<X, T, Method> {
    private MethodInjectionPoint<T, ? super X> method;
    private ProducerMethod<?, ?> specializedBean;
    private final String id;
    private final boolean proxiable;

    public static <X, T> ProducerMethod<X, T> of(BeanAttributes<T> attributes, WeldMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager, ServiceRegistry services) {
        return new ProducerMethod<X, T>(attributes, method, declaringBean, beanManager, services);
    }

    protected ProducerMethod(BeanAttributes<T> attributes, WeldMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(attributes, ProducerMethod.class.getSimpleName() + "-" + declaringBean.getWeldAnnotated().getName() + "." + method.getSignature().toString(), declaringBean, beanManager, services);
        this.id = this.createId(method, declaringBean);
        this.method = MethodInjectionPoint.of(method, this, beanManager);
        this.initType();
        this.initProducerMethodInjectableParameters();
        this.proxiable = Proxies.isTypesProxyable(method.getTypeClosure());
    }

    protected String createId(WeldMethod<T, ? super X> method, AbstractClassBean<X> declaringBean) {
        if (declaringBean.getWeldAnnotated().isDiscovered()) {
            StringBuilder sb = new StringBuilder();
            sb.append(BEAN_ID_PREFIX);
            sb.append(ProducerMethod.class.getSimpleName());
            sb.append("-");
            sb.append(declaringBean.getWeldAnnotated().getName());
            sb.append(method.getSignature().toString());
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(BEAN_ID_PREFIX);
        sb.append(ProducerMethod.class.getSimpleName());
        sb.append("-");
        sb.append(AnnotatedTypes.createTypeId(declaringBean.getWeldAnnotated()));
        sb.append(AnnotatedTypes.createCallableId(method));
        return sb.toString();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.checkProducerMethod();
            this.setProducer(new AbstractProducerBean.AbstractProducer(){

                @Override
                public T produce(CreationalContext<T> creationalContext) {
                    Object receiver = ProducerMethod.this.getReceiver(creationalContext);
                    if (receiver != null) {
                        return ProducerMethod.this.method.invokeOnInstance(receiver, ProducerMethod.this.beanManager, creationalContext, CreationException.class);
                    }
                    return ProducerMethod.this.method.invoke(null, ProducerMethod.this.beanManager, creationalContext, CreationException.class);
                }

                public String toString() {
                    return ProducerMethod.this.method.toString();
                }
            });
        }
    }

    protected void initProducerMethodInjectableParameters() {
        for (ParameterInjectionPoint ip : this.method.getParameterInjectionPoints()) {
            this.addInjectionPoint(ip);
        }
    }

    protected void checkProducerMethod() {
        if (this.getWeldAnnotated().getWeldParameters(Observes.class).size() > 0) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Produces", "@Observes");
        }
        if (this.getWeldAnnotated().getWeldParameters(Disposes.class).size() > 0) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Produces", "@Disposes");
        }
        if (this.getDeclaringBean() instanceof SessionBean) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.getDeclaringBean().getTypes()) {
                if (!(type instanceof Class) || !SecureReflections.isMethodExists((Class)type, this.getWeldAnnotated().getName(), this.getWeldAnnotated().getParameterTypesAsArray())) continue;
                methodDeclaredOnTypes = true;
            }
            if (!methodDeclaredOnTypes) {
                throw new DefinitionException(BeanMessage.METHOD_NOT_BUSINESS_METHOD, this, this.getDeclaringBean());
            }
        }
    }

    @Override
    public WeldMethod<T, ? super X> getWeldAnnotated() {
        return this.method.getAnnotated();
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    protected void preSpecialize() {
        if (this.getDeclaringBean().getWeldAnnotated().getWeldSuperclass().getDeclaredWeldMethod((Method)this.getWeldAnnotated().getJavaMember()) == null) {
            throw new DefinitionException(BeanMessage.PRODUCER_METHOD_NOT_SPECIALIZING, this);
        }
    }

    @Override
    protected void specialize() {
        WeldMethod<?, ?> superClassMethod;
        BeansClosure closure = BeansClosure.getClosure(this.beanManager);
        ProducerMethod<?, ?> check = closure.getProducerMethod(superClassMethod = this.getDeclaringBean().getWeldAnnotated().getWeldSuperclass().getWeldMethod((Method)this.getWeldAnnotated().getJavaMember()));
        if (check == null) {
            throw new IllegalStateException(BeanMessage.PRODUCER_METHOD_NOT_SPECIALIZING, this);
        }
        this.specializedBean = check;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String toString() {
        return "Producer Method [" + Formats.formatType(this.getWeldAnnotated().getBaseType()) + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "] declared as [" + this.getWeldAnnotated() + "]";
    }

    @Override
    public boolean isProxyable() {
        return this.proxiable;
    }
}

