/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.bean.SyntheticClassBean;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntheticDecorator<T>
extends SyntheticClassBean<T>
implements Decorator<T> {
    private final InjectionPoint delegate = this.identifyDelegateInjectionPoint(this.getInjectionPoints());
    private final Set<Type> decoratedTypes;

    public SyntheticDecorator(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTarget<T> producer, BeanManagerImpl manager) {
        super(attributes, beanClass, producer, manager);
        this.decoratedTypes = Collections.unmodifiableSet(this.getDecoratedTypes(attributes.getTypes()));
    }

    protected InjectionPoint identifyDelegateInjectionPoint(Set<InjectionPoint> injectionPoints) {
        InjectionPoint delegate = null;
        for (InjectionPoint injectionPoint : injectionPoints) {
            if (!injectionPoint.isDelegate()) continue;
            if (delegate != null) {
                throw new DefinitionException(BeanMessage.TOO_MANY_DELEGATES_FOR_DECORATOR, this.getBeanClass());
            }
            delegate = injectionPoint;
        }
        if (delegate == null) {
            throw new DefinitionException(BeanMessage.NO_DELEGATE_FOR_DECORATOR, this.getBeanClass());
        }
        return delegate;
    }

    protected Set<Type> getDecoratedTypes(Set<Type> types) {
        HashSet<Type> decoratedTypes = new HashSet<Type>();
        for (Type type : types) {
            Class rawType = Reflections.getRawType(type);
            if (!rawType.isInterface() || Serializable.class.equals(rawType)) continue;
            decoratedTypes.add(type);
        }
        return decoratedTypes;
    }

    @Override
    public Type getDelegateType() {
        return this.delegate.getType();
    }

    @Override
    public Set<Annotation> getDelegateQualifiers() {
        return this.delegate.getQualifiers();
    }

    @Override
    public Set<Type> getDecoratedTypes() {
        return this.decoratedTypes;
    }
}

