/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Set;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanAttributes;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bean.attributes.ExternalBeanAttributesFactory;
import org.jboss.weld.bean.builtin.ee.EEResourceProducerField;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.events.ProcessBeanAttributesImpl;
import org.jboss.weld.bootstrap.events.ProcessBeanImpl;
import org.jboss.weld.bootstrap.events.ProcessBeanInjectionTarget;
import org.jboss.weld.bootstrap.events.ProcessManagedBeanImpl;
import org.jboss.weld.bootstrap.events.ProcessObserverMethodImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerFieldImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerImpl;
import org.jboss.weld.bootstrap.events.ProcessProducerMethodImpl;
import org.jboss.weld.bootstrap.events.ProcessSessionBeanImpl;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.ws.WSApiAbstraction;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBeanDeployer<E extends BeanDeployerEnvironment> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private final BeanManagerImpl manager;
    private final ServiceRegistry services;
    private final E environment;

    public AbstractBeanDeployer(BeanManagerImpl manager, ServiceRegistry services, E environment) {
        this.manager = manager;
        this.services = services;
        this.environment = environment;
    }

    protected BeanManagerImpl getManager() {
        return this.manager;
    }

    public AbstractBeanDeployer<E> deploySpecialized() {
        for (DecoratorImpl<?> decoratorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getDecorators()) {
            decoratorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            ProcessBeanImpl.fire(this.getManager(), decoratorImpl);
            this.manager.addDecorator(decoratorImpl);
            log.debug(BootstrapMessage.FOUND_DECORATOR, decoratorImpl);
        }
        for (InterceptorImpl interceptorImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors()) {
            interceptorImpl.initialize((BeanDeployerEnvironment)this.getEnvironment());
            ProcessBeanImpl.fire(this.getManager(), interceptorImpl);
            this.manager.addInterceptor(interceptorImpl);
            log.debug(BootstrapMessage.FOUND_INTERCEPTOR, interceptorImpl);
        }
        return this;
    }

    public AbstractBeanDeployer<E> deploy() {
        Set<RIBean<?>> beans = ((BeanDeployerEnvironment)this.getEnvironment()).getBeans();
        for (RIBean<?> rIBean : beans) {
            rIBean.initialize((BeanDeployerEnvironment)this.getEnvironment());
            if (!(rIBean instanceof NewBean)) {
                if (rIBean instanceof AbstractProducerBean) {
                    ProcessProducerImpl.fire(this.manager, (AbstractProducerBean)Reflections.cast(rIBean));
                } else if (rIBean instanceof AbstractClassBean) {
                    ProcessBeanInjectionTarget.fire(this.manager, (AbstractClassBean)rIBean);
                }
                if (rIBean instanceof ManagedBean) {
                    ProcessManagedBeanImpl.fire(this.manager, (ManagedBean)rIBean);
                } else if (rIBean instanceof SessionBean) {
                    ProcessSessionBeanImpl.fire(this.manager, (SessionBean)Reflections.cast(rIBean));
                } else if (rIBean instanceof ProducerField) {
                    ProcessProducerFieldImpl.fire(this.manager, (ProducerField)rIBean);
                } else if (rIBean instanceof ProducerMethod) {
                    ProcessProducerMethodImpl.fire(this.manager, (ProducerMethod)rIBean);
                } else {
                    ProcessBeanImpl.fire(this.getManager(), rIBean);
                }
            }
            this.manager.addBean(rIBean);
            log.debug(BootstrapMessage.FOUND_BEAN, rIBean);
        }
        for (ObserverMethodImpl observerMethodImpl : ((BeanDeployerEnvironment)this.getEnvironment()).getObservers()) {
            if (!Observers.isObserverMethodEnabled(observerMethodImpl, this.manager)) continue;
            log.debug(BootstrapMessage.FOUND_OBSERVER_METHOD, observerMethodImpl);
            observerMethodImpl.initialize();
            ProcessObserverMethodImpl.fire(this.manager, observerMethodImpl);
            this.manager.addObserver(observerMethodImpl);
        }
        return this;
    }

    protected <T> void createObserversProducersDisposers(AbstractClassBean<T> bean) {
        if (bean instanceof ManagedBean || bean instanceof SessionBean) {
            this.createProducerMethods((AbstractClassBean)bean, (WeldClass)bean.getWeldAnnotated());
            this.createProducerFields((AbstractClassBean)bean, (WeldClass)bean.getWeldAnnotated());
            if (this.manager.isBeanEnabled(bean)) {
                this.createObserverMethods((RIBean)bean, (WeldClass)bean.getWeldAnnotated());
            }
            this.createDisposalMethods((AbstractClassBean)bean, (WeldClass)bean.getWeldAnnotated());
        }
    }

    protected <X> void createProducerMethods(AbstractClassBean<X> declaringBean, WeldClass<X> annotatedClass) {
        for (WeldMethod<?, X> method : annotatedClass.getDeclaredWeldMethods(Produces.class)) {
            this.createProducerMethod(declaringBean, method);
        }
    }

    protected <X> void createDisposalMethods(AbstractClassBean<X> declaringBean, WeldClass<X> annotatedClass) {
        for (WeldMethod<?, X> method : annotatedClass.getDeclaredWeldMethodsWithAnnotatedParameters(Disposes.class)) {
            DisposalMethod<X, ?> disposalBean = DisposalMethod.of(this.manager, method, declaringBean);
            disposalBean.initialize((BeanDeployerEnvironment)this.getEnvironment());
            ((BeanDeployerEnvironment)this.getEnvironment()).addDisposesMethod(disposalBean);
        }
    }

    protected <X, T> void createProducerMethod(AbstractClassBean<X> declaringBean, WeldMethod<T, ? super X> annotatedMethod) {
        BeanAttributes attributes = BeanAttributesFactory.forProducerBean(annotatedMethod, declaringBean, this.getManager());
        ProducerMethod bean = ProducerMethod.of(attributes, annotatedMethod, declaringBean, this.manager, this.services);
        ((BeanDeployerEnvironment)this.getEnvironment()).addProducerMethod(bean);
    }

    protected <X, T> void createProducerField(AbstractClassBean<X> declaringBean, WeldField<T, ? super X> field) {
        BeanAttributes attributes = BeanAttributesFactory.forProducerBean(field, declaringBean, this.getManager());
        ProducerField bean = this.isEEResourceProducerField(field) ? EEResourceProducerField.of(attributes, field, declaringBean, this.manager, this.services) : ProducerField.of(attributes, field, declaringBean, this.manager, this.services);
        boolean vetoed = this.fireProcessBeanAttributes(bean);
        if (!vetoed) {
            ((BeanDeployerEnvironment)this.getEnvironment()).addProducerField(bean);
        }
    }

    protected <X> void createProducerFields(AbstractClassBean<X> declaringBean, WeldClass<X> annotatedClass) {
        for (WeldField<?, X> field : annotatedClass.getDeclaredWeldFields(Produces.class)) {
            this.createProducerField(declaringBean, field);
        }
    }

    protected <X> void createObserverMethods(RIBean<X> declaringBean, WeldClass<? super X> annotatedClass) {
        for (WeldMethod<?, ? super X> weldMethod : Beans.getObserverMethods(annotatedClass)) {
            this.createObserverMethod(declaringBean, weldMethod);
        }
    }

    protected <T, X> void createObserverMethod(RIBean<X> declaringBean, WeldMethod<T, ? super X> method) {
        ObserverMethodImpl<T, ? super X> observer = ObserverFactory.create(method, declaringBean, this.manager);
        ((BeanDeployerEnvironment)this.getEnvironment()).addObserverMethod(observer);
    }

    protected <T> ManagedBean<T> createManagedBean(WeldClass<T> weldClass) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forManagedBean(weldClass, this.getManager());
        ManagedBean<T> bean = ManagedBean.of(attributes, weldClass, this.manager, this.services);
        ((BeanDeployerEnvironment)this.getEnvironment()).addManagedBean(bean);
        return bean;
    }

    protected <T> void createNewManagedBean(WeldClass<T> annotatedClass) {
        ((BeanDeployerEnvironment)this.getEnvironment()).addManagedBean(NewManagedBean.of(BeanAttributesFactory.forNewManagedBean(annotatedClass), annotatedClass, this.manager, this.services));
    }

    protected <T> void createDecorator(WeldClass<T> weldClass) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forManagedBean(weldClass, this.getManager());
        DecoratorImpl<T> bean = DecoratorImpl.of(attributes, weldClass, this.manager, this.services);
        boolean vetoed = this.fireProcessBeanAttributes(bean);
        if (!vetoed) {
            ((BeanDeployerEnvironment)this.getEnvironment()).addDecorator(bean);
        }
    }

    protected <T> void createInterceptor(WeldClass<T> weldClass) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forManagedBean(weldClass, this.getManager());
        InterceptorImpl<T> bean = InterceptorImpl.of(attributes, weldClass, this.manager, this.services);
        boolean vetoed = this.fireProcessBeanAttributes(bean);
        if (!vetoed) {
            ((BeanDeployerEnvironment)this.getEnvironment()).addInterceptor(bean);
        }
    }

    protected <T> SessionBean<T> createSessionBean(InternalEjbDescriptor<T> descriptor) {
        return this.createSessionBean(descriptor, this.services.get(ClassTransformer.class).loadClass(descriptor.getBeanClass()));
    }

    protected <T> SessionBean<T> createSessionBean(InternalEjbDescriptor<T> descriptor, WeldClass<T> weldClass) {
        BeanAttributes<T> attributes = BeanAttributesFactory.forSessionBean(weldClass, descriptor, this.getManager());
        SessionBean<T> bean = SessionBean.of(attributes, descriptor, this.manager, weldClass, this.services);
        ((BeanDeployerEnvironment)this.getEnvironment()).addSessionBean(bean);
        return bean;
    }

    protected <T> void createNewSessionBean(InternalEjbDescriptor<T> ejbDescriptor, BeanAttributes<?> originalAttributes) {
        BeanAttributes attributes = (BeanAttributes)Reflections.cast(BeanAttributesFactory.forNewSessionBean(originalAttributes));
        ((BeanDeployerEnvironment)this.getEnvironment()).addSessionBean(NewSessionBean.of(attributes, ejbDescriptor, this.manager, this.services));
    }

    protected boolean isEEResourceProducerField(WeldField<?, ?> field) {
        EJBApiAbstraction ejbApiAbstraction = this.manager.getServices().get(EJBApiAbstraction.class);
        PersistenceApiAbstraction persistenceApiAbstraction = this.manager.getServices().get(PersistenceApiAbstraction.class);
        WSApiAbstraction wsApiAbstraction = this.manager.getServices().get(WSApiAbstraction.class);
        return field.isAnnotationPresent(ejbApiAbstraction.EJB_ANNOTATION_CLASS) || field.isAnnotationPresent(ejbApiAbstraction.RESOURCE_ANNOTATION_CLASS) || field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_UNIT_ANNOTATION_CLASS) || field.isAnnotationPresent(persistenceApiAbstraction.PERSISTENCE_CONTEXT_ANNOTATION_CLASS) || field.isAnnotationPresent(wsApiAbstraction.WEB_SERVICE_REF_ANNOTATION_CLASS);
    }

    public E getEnvironment() {
        return this.environment;
    }

    protected <T, S> boolean fireProcessBeanAttributes(AbstractBean<T, S> bean) {
        if (!this.getManager().isBeanEnabled(bean) || Beans.isSpecialized(bean, this.getManager()) || Beans.isSuppressedBySpecialization(bean, this.getManager())) {
            return false;
        }
        ProcessBeanAttributesImpl event = ProcessBeanAttributesImpl.fire(this.getManager(), bean, bean.getWeldAnnotated(), bean.getType());
        if (event.isVeto()) {
            return true;
        }
        if (event.isDirty()) {
            bean.setAttributes(ExternalBeanAttributesFactory.of(event.getBeanAttributes(), this.manager));
            bean.checkSpecialization();
        }
        return false;
    }
}

