/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.ProcessModule;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.events.AbstractDeploymentContainerEvent;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.event.ExtensionObserverMethodImpl;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.MetadataImpl;
import org.jboss.weld.util.collections.ListView;
import org.jboss.weld.util.collections.SetView;
import org.jboss.weld.util.collections.ViewProvider;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessModuleImpl
extends AbstractDeploymentContainerEvent
implements ProcessModule {
    private final BeanDeployment deployment;
    private final ClassMetadaViewProvider viewProvider = new ClassMetadaViewProvider();

    public static ProcessModuleImpl fire(BeanDeployment deployment) {
        ProcessModuleImpl event = new ProcessModuleImpl(deployment.getBeanManager(), deployment);
        event.fire();
        return event;
    }

    protected ProcessModuleImpl(BeanManagerImpl beanManager, BeanDeployment deployment) {
        super(beanManager, (Type)((Object)ProcessModule.class), Reflections.EMPTY_TYPES);
        this.deployment = deployment;
    }

    @Override
    public Set<Class<?>> getAlternatives() {
        return new SetView<Metadata<Class<?>>, Class<?>>(){

            @Override
            protected Set<Metadata<Class<?>>> getDelegate() {
                return ProcessModuleImpl.this.deployment.getEnabledBuilder().getAlternativeClasses();
            }

            @Override
            protected ViewProvider<Metadata<Class<?>>, Class<?>> getViewProvider() {
                return ProcessModuleImpl.this.viewProvider;
            }
        };
    }

    @Override
    public List<Class<?>> getInterceptors() {
        return new ListView<Metadata<Class<?>>, Class<?>>(){

            @Override
            protected List<Metadata<Class<?>>> getDelegate() {
                return ProcessModuleImpl.this.deployment.getEnabledBuilder().getInterceptors();
            }

            @Override
            protected ViewProvider<Metadata<Class<?>>, Class<?>> getViewProvider() {
                return ProcessModuleImpl.this.viewProvider;
            }
        };
    }

    @Override
    public List<Class<?>> getDecorators() {
        return new ListView<Metadata<Class<?>>, Class<?>>(){

            @Override
            protected List<Metadata<Class<?>>> getDelegate() {
                return ProcessModuleImpl.this.deployment.getEnabledBuilder().getDecorators();
            }

            @Override
            protected ViewProvider<Metadata<Class<?>>, Class<?>> getViewProvider() {
                return ProcessModuleImpl.this.viewProvider;
            }
        };
    }

    @Override
    public Iterator<AnnotatedType<?>> getAnnotatedTypes() {
        return (Iterator)Reflections.cast(this.deployment.getBeanDeployer().getClasses().iterator());
    }

    @Override
    public InputStream getBeansXml() {
        try {
            return this.deployment.getBeanDeploymentArchive().getBeansXml().getUrl().openStream();
        }
        catch (IOException e) {
            throw new WeldException(XmlMessage.EXCEPTION_OPENING_INPUT_STREAM, (Throwable)e, this.deployment.getBeanDeploymentArchive().getBeansXml().getUrl());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassMetadaViewProvider
    implements ViewProvider<Metadata<Class<?>>, Class<?>> {
        private ClassMetadaViewProvider() {
        }

        @Override
        public Class<?> toView(Metadata<Class<?>> from) {
            return from.getValue();
        }

        @Override
        public Metadata<Class<?>> fromView(Class<?> to) {
            StringBuilder location = new StringBuilder();
            location.append(to.getName());
            location.append(" registered by ");
            if (ProcessModuleImpl.this.getObserverMethod() instanceof ExtensionObserverMethodImpl) {
                location.append(((ExtensionObserverMethodImpl)ProcessModuleImpl.this.getObserverMethod()).getBeanClass().getName());
            } else {
                location.append("an extension.");
            }
            return new MetadataImpl(to, location.toString());
        }
    }
}

