/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.enums;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.collections.ArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumInjectionTarget<T extends Enum<?>>
implements InjectionTarget<T> {
    private final List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private final List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;
    private final Set<WeldInjectionPoint<?, ?>> ejbInjectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> persistenceContextInjectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> persistenceUnitInjectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> resourceInjectionPoints;
    private final ArraySet<WeldInjectionPoint<?, ?>> injectionPoints;
    private final ArraySet<WeldInjectionPoint<?, ?>> newInjectionPoints;
    private final WeldClass<T> weldClass;
    private final BeanManagerImpl manager;

    public static <T extends Enum<?>> EnumInjectionTarget<T> of(WeldClass<T> clazz, BeanManagerImpl manager) {
        return new EnumInjectionTarget<T>(clazz, manager);
    }

    public EnumInjectionTarget(WeldClass<T> weldClass, BeanManagerImpl manager) {
        this.manager = manager;
        this.weldClass = weldClass;
        this.injectionPoints = new ArraySet();
        this.newInjectionPoints = new ArraySet();
        this.injectableFields = Beans.getFieldInjectionPoints(null, weldClass, manager);
        this.ejbInjectionPoints = Beans.getEjbInjectionPoints(null, weldClass, manager);
        this.persistenceContextInjectionPoints = Beans.getPersistenceContextInjectionPoints(null, weldClass, manager);
        this.persistenceUnitInjectionPoints = Beans.getPersistenceUnitInjectionPoints(null, weldClass, manager);
        this.resourceInjectionPoints = Beans.getResourceInjectionPoints(null, weldClass, manager);
        this.initializerMethods = Beans.getInitializerMethods(null, weldClass, manager);
        this.addInjectionPoints(Beans.flattenInjectionPoints(this.injectableFields));
        this.addInjectionPoints(Beans.flattenParameterInjectionPoints(this.initializerMethods));
        this.injectionPoints.trimToSize();
        this.newInjectionPoints.trimToSize();
    }

    @Override
    public void inject(T instance, CreationalContext<T> ctx) {
        Beans.injectEEFields(instance, this.manager, this.ejbInjectionPoints, this.persistenceContextInjectionPoints, this.persistenceUnitInjectionPoints, this.resourceInjectionPoints);
        Beans.injectFieldsAndInitializers(instance, ctx, this.manager, this.injectableFields, this.initializerMethods);
    }

    @Override
    public void dispose(T instance) {
        this.disinject(this.ejbInjectionPoints, instance);
        this.disinject(this.persistenceContextInjectionPoints, instance);
        this.disinject(this.persistenceUnitInjectionPoints, instance);
        this.disinject(this.resourceInjectionPoints, instance);
        for (Set<FieldInjectionPoint<?, ?>> fields : this.injectableFields) {
            this.disinject(fields, instance);
        }
    }

    protected void disinject(Set<? extends WeldInjectionPoint<?, ?>> injectionPoints, T instance) {
        for (WeldInjectionPoint<?, ?> ip : injectionPoints) {
            ip.inject(instance, null);
        }
    }

    protected <X extends WeldInjectionPoint<?, ?>> void addInjectionPoints(Iterable<X> injectionPoints) {
        for (WeldInjectionPoint ip : injectionPoints) {
            this.addInjectionPoint(ip);
        }
    }

    protected void addInjectionPoint(WeldInjectionPoint<?, ?> ip) {
        if (ip.getQualifier(New.class) != null) {
            this.newInjectionPoints.add(ip);
        }
        this.injectionPoints.add(ip);
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.unmodifiableSet(this.injectionPoints);
    }

    public Set<WeldInjectionPoint<?, ?>> getNewInjectionPoints() {
        return Collections.unmodifiableSet(this.newInjectionPoints);
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void postConstruct(T instance) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void preDestroy(T instance) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "EnumInjectionTarget for " + this.weldClass;
    }
}

