/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMember;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberTransformer
implements Service {
    private final ConcurrentMap<AnnotatedMember<?>, WeldMember<?, ?, ?>> memberCache;
    private final ClassTransformer transformer;
    private final FieldLoader fieldLoader;
    private final MethodLoader methodLoader;
    private final ConstructorLoader constructorLoader;

    public MemberTransformer(ClassTransformer transformer) {
        this.transformer = transformer;
        this.fieldLoader = new FieldLoader();
        this.methodLoader = new MethodLoader();
        this.constructorLoader = new ConstructorLoader();
        this.memberCache = new MapMaker().makeComputingMap(new TransformationFunction());
    }

    public <T, X> WeldField<T, X> load(AnnotatedField<X> field) {
        if (field instanceof WeldField) {
            return (WeldField)Reflections.cast(field);
        }
        return (WeldField)Reflections.cast(this.memberCache.get(field));
    }

    public <T, X> WeldMethod<T, X> load(AnnotatedMethod<X> method) {
        if (method instanceof WeldMethod) {
            return (WeldMethod)Reflections.cast(method);
        }
        return (WeldMethod)Reflections.cast(this.memberCache.get(method));
    }

    public <T> WeldConstructor<T> load(AnnotatedConstructor<T> constructor) {
        if (constructor instanceof WeldConstructor) {
            return (WeldConstructor)Reflections.cast(constructor);
        }
        return (WeldConstructor)Reflections.cast(this.memberCache.get(constructor));
    }

    public <T, X> WeldParameter<T, X> load(AnnotatedParameter<X> parameter) {
        if (parameter instanceof WeldParameter) {
            return (WeldParameter)Reflections.cast(parameter);
        }
        if (parameter.getDeclaringCallable() instanceof AnnotatedMethod) {
            return (WeldParameter)Reflections.cast(this.load((AnnotatedMethod)parameter.getDeclaringCallable()).getWeldParameters().get(parameter.getPosition()));
        }
        if (parameter.getDeclaringCallable() instanceof AnnotatedConstructor) {
            return (WeldParameter)Reflections.cast(this.load((AnnotatedConstructor)parameter.getDeclaringCallable()).getWeldParameters().get(parameter.getPosition()));
        }
        throw new IllegalArgumentException(BeanMessage.INVALID_ANNOTATED_CALLABLE, parameter.getDeclaringCallable());
    }

    @Override
    public void cleanup() {
        this.memberCache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstructorLoader
    extends AbstractMemberLoader<AnnotatedConstructor<?>, WeldConstructor<?>> {
        private ConstructorLoader() {
        }

        @Override
        public boolean equals(WeldConstructor<?> member1, AnnotatedConstructor<?> member2) {
            return AnnotatedTypes.compareAnnotatedCallable(member1, member2);
        }

        @Override
        public Collection<WeldConstructor<?>> getMembersOfDeclaringType(AnnotatedConstructor<?> source) {
            return (Collection)Reflections.cast(MemberTransformer.this.transformer.loadClass(source.getDeclaringType()).getWeldConstructors());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodLoader
    extends AbstractMemberLoader<AnnotatedMethod<?>, WeldMethod<?, ?>> {
        private MethodLoader() {
        }

        @Override
        public boolean equals(WeldMethod<?, ?> member1, AnnotatedMethod<?> member2) {
            return AnnotatedTypes.compareAnnotatedCallable(member1, member2);
        }

        @Override
        public Collection<WeldMethod<?, ?>> getMembersOfDeclaringType(AnnotatedMethod<?> source) {
            return (Collection)Reflections.cast(MemberTransformer.this.transformer.loadClass(source.getDeclaringType()).getDeclaredWeldMethods());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldLoader
    extends AbstractMemberLoader<AnnotatedField<?>, WeldField<?, ?>> {
        private FieldLoader() {
        }

        @Override
        public boolean equals(WeldField<?, ?> member1, AnnotatedField<?> member2) {
            return AnnotatedTypes.compareAnnotatedField(member1, member2);
        }

        @Override
        public Collection<WeldField<?, ?>> getMembersOfDeclaringType(AnnotatedField<?> source) {
            return (Collection)Reflections.cast(MemberTransformer.this.transformer.loadClass(source.getDeclaringType()).getDeclaredWeldFields());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractMemberLoader<A extends AnnotatedMember<?>, W extends WeldMember<?, ?, ?>> {
        private AbstractMemberLoader() {
        }

        public W load(A source) {
            return this.findMatching(this.getMembersOfDeclaringType(source), source);
        }

        public W findMatching(Collection<W> members, A source) {
            for (WeldMember member : members) {
                if (!this.equals(member, source)) continue;
                return (W)member;
            }
            throw new IllegalStateException(BeanMessage.UNABLE_TO_LOAD_MEMBER, source);
        }

        public abstract boolean equals(W var1, A var2);

        public abstract Collection<W> getMembersOfDeclaringType(A var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformationFunction
    implements Function<AnnotatedMember<?>, WeldMember<?, ?, ?>> {
        private TransformationFunction() {
        }

        @Override
        public WeldMember<?, ?, ?> apply(AnnotatedMember<?> from) {
            if (from instanceof AnnotatedField) {
                return MemberTransformer.this.fieldLoader.load((AnnotatedMember)Reflections.cast(from));
            }
            if (from instanceof AnnotatedMethod) {
                return MemberTransformer.this.methodLoader.load((AnnotatedMember)Reflections.cast(from));
            }
            if (from instanceof AnnotatedConstructor) {
                return MemberTransformer.this.constructorLoader.load((AnnotatedMember)Reflections.cast(from));
            }
            throw new IllegalArgumentException(BeanMessage.INVALID_ANNOTATED_MEMBER, from);
        }
    }
}

