/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.serialization.AbstractWeldAnnotatedHolder;
import org.jboss.weld.serialization.SerializableHolder;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveredWeldFieldSerializableHolder<T, X>
extends AbstractWeldAnnotatedHolder<X>
implements SerializableHolder<WeldField<T, X>> {
    private static final long serialVersionUID = -5186616992990718551L;
    private final String name;
    private transient WeldField<T, X> field;

    public DiscoveredWeldFieldSerializableHolder(WeldField<T, X> field) {
        super(field.getDeclaringType().getJavaClass());
        this.field = field;
        this.name = field.getName();
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.field = (WeldField)Reflections.cast(this.getDeclaringWeldClass().getDeclaredWeldField(this.name));
        if (this.field == null) {
            throw new IllegalStateException(ReflectionMessage.UNABLE_TO_GET_FIELD_ON_DESERIALIZATION, this.getDeclaringWeldClass(), this.name);
        }
    }

    @Override
    public WeldField<T, X> get() {
        return this.field;
    }
}

