/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.util.reflection.GenericArrayTypeImpl;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;
import org.jboss.weld.util.reflection.RawType;
import org.jboss.weld.util.reflection.Reflections;

public class Types {
    private Types() {
    }

    public static Type boxedType(Type type) {
        if (type instanceof Class) {
            return Types.boxedClass((Class)type);
        }
        return type;
    }

    public static Class<?> boxedClass(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Void.TYPE)) {
            return Void.class;
        }
        return type;
    }

    public static String getTypeId(Type type) {
        if (type instanceof Class) {
            return ((Class)Reflections.cast(type)).getName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder(Types.getTypeId(pt.getRawType()));
            builder.append("<");
            for (int i = 0; i < pt.getActualTypeArguments().length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(Types.getTypeId(pt.getActualTypeArguments()[i]));
            }
            builder.append(">");
            return builder.toString();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            StringBuilder builder = new StringBuilder(Types.getTypeId(arrayType.getGenericComponentType()));
            builder.append("[]");
            return builder.toString();
        }
        throw new IllegalArgumentException("Cannot create type id for" + type.toString());
    }

    public static Type getCanonicalType(Class<?> clazz) {
        Type resolvedComponentType;
        Class<?> componentType;
        if (clazz.isArray() && (componentType = clazz.getComponentType()) != (resolvedComponentType = Types.getCanonicalType(componentType))) {
            return new GenericArrayTypeImpl(resolvedComponentType);
        }
        if (clazz.getTypeParameters().length > 0) {
            Type[] actualTypeParameters = clazz.getTypeParameters();
            return new ParameterizedTypeImpl(clazz, actualTypeParameters, clazz.getDeclaringClass());
        }
        return clazz;
    }

    public static Type getCanonicalType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return Types.getCanonicalType(clazz);
        }
        if (type instanceof RawType) {
            RawType rawType = (RawType)type;
            return rawType.getType();
        }
        return type;
    }

    public static boolean containsUnresolvedTypeVariableOrWildcard(Type type) {
        if ((type = Types.getCanonicalType(type)) instanceof TypeVariable || type instanceof WildcardType) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type t : parameterizedType.getActualTypeArguments()) {
                if (!Types.containsUnresolvedTypeVariableOrWildcard(t)) continue;
                return true;
            }
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return Types.containsUnresolvedTypeVariableOrWildcard(genericArrayType.getGenericComponentType());
        }
        return false;
    }

    public static Set<Class<?>> getRawTypes(Set<Type> types) {
        return ImmutableSet.copyOf(Iterables.transform(types, new Function<Type, Class<?>>(){

            @Override
            public Class<?> apply(Type input) {
                return Reflections.getRawType(input);
            }
        }));
    }

    public static <C extends Class<?>> Map<String, C> buildClassNameMap(Iterable<C> set) {
        HashMap<String, Class> loadedStereotypes = new HashMap<String, Class>();
        for (Class javaClass : set) {
            loadedStereotypes.put(javaClass.getName(), javaClass);
        }
        return loadedStereotypes;
    }
}

