/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.jboss.weld.interceptor.reader.AnnotatedMethodReader;
import org.jboss.weld.interceptor.reader.ReflectiveAnnotatedMethodReader;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionTypeRegistry;
import org.jboss.weld.resources.SharedObjectFacade;
import org.jboss.weld.serialization.MethodHolder;
import org.jboss.weld.util.collections.ArraySet;

@SuppressWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="False positive from FindBugs - serialization is handled by SerializationProxy.")
public class DefaultMethodMetadata<M>
implements MethodMetadata,
Serializable {
    private static final long serialVersionUID = -4538617003189564552L;
    private final Method javaMethod;
    private final Set<InterceptionType> supportedInterceptorTypes;

    private DefaultMethodMetadata(M methodReference, AnnotatedMethodReader<M> annotationReader) {
        this.javaMethod = annotationReader.getJavaMethod(methodReference);
        ArraySet<InterceptionType> supportedInterceptorTypes = new ArraySet<InterceptionType>();
        for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
            if (annotationReader.getAnnotation(InterceptionTypeRegistry.getAnnotationClass(interceptionType), methodReference) == null) continue;
            supportedInterceptorTypes.add(interceptionType);
        }
        this.supportedInterceptorTypes = supportedInterceptorTypes.isEmpty() ? Collections.emptySet() : SharedObjectFacade.wrap(supportedInterceptorTypes);
    }

    private DefaultMethodMetadata(Set<InterceptionType> interceptionTypes, MethodHolder methodHolder) {
        this.supportedInterceptorTypes = interceptionTypes;
        this.javaMethod = (Method)methodHolder.get();
    }

    public static <M> MethodMetadata of(M methodReference, AnnotatedMethodReader<M> methodReader) {
        return new DefaultMethodMetadata<M>(methodReference, methodReader);
    }

    public static MethodMetadata of(Method method) {
        return new DefaultMethodMetadata<Method>(method, new ReflectiveAnnotatedMethodReader());
    }

    @Override
    public boolean isInterceptorMethod() {
        return !this.supportedInterceptorTypes.isEmpty();
    }

    @Override
    public Set<InterceptionType> getSupportedInterceptionTypes() {
        return this.supportedInterceptorTypes;
    }

    @Override
    public Method getJavaMethod() {
        return this.javaMethod;
    }

    @Override
    public Class<?> getReturnType() {
        return this.javaMethod.getReturnType();
    }

    private Object writeReplace() {
        return new DefaultMethodMetadataSerializationProxy(this.supportedInterceptorTypes, MethodHolder.of(this));
    }

    private static class DefaultMethodMetadataSerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 6505717058846166714L;
        private final Set<InterceptionType> supportedInterceptionTypes;
        private final MethodHolder methodHolder;

        private DefaultMethodMetadataSerializationProxy(Set<InterceptionType> supportedInterceptionTypes, MethodHolder methodHolder) {
            this.supportedInterceptionTypes = supportedInterceptionTypes;
            this.methodHolder = methodHolder;
        }

        private Object readResolve() throws ObjectStreamException {
            return new DefaultMethodMetadata(this.supportedInterceptionTypes, this.methodHolder);
        }
    }
}

