/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Method;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractSyntheticBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.DeclaredMemberIndexer;

public class BeanIdentifiers {
    public static final String PREFIX = "WELD|";
    public static final String SEPARATOR = "|";

    private BeanIdentifiers() {
    }

    private static StringBuilder getPrefix(Class<?> beanType) {
        return new StringBuilder(PREFIX).append(beanType.getSimpleName()).append(SEPARATOR);
    }

    public static String forManagedBean(EnhancedAnnotatedType<?> type) {
        return BeanIdentifiers.forManagedBean((AnnotatedTypeIdentifier)type.slim().getIdentifier());
    }

    public static String forManagedBean(AnnotatedTypeIdentifier identifier) {
        return BeanIdentifiers.getPrefix(ManagedBean.class).append(identifier.asString()).toString();
    }

    public static String forDecorator(EnhancedAnnotatedType<?> type) {
        return BeanIdentifiers.getPrefix(DecoratorImpl.class).append(((AnnotatedTypeIdentifier)type.slim().getIdentifier()).asString()).toString();
    }

    public static String forInterceptor(EnhancedAnnotatedType<?> type) {
        return BeanIdentifiers.getPrefix(InterceptorImpl.class).append(((AnnotatedTypeIdentifier)type.slim().getIdentifier()).asString()).toString();
    }

    public static String forNewManagedBean(EnhancedAnnotatedType<?> type) {
        return BeanIdentifiers.getPrefix(NewManagedBean.class).append(((AnnotatedTypeIdentifier)type.slim().getIdentifier()).asString()).toString();
    }

    public static String forSessionBean(EnhancedAnnotatedType<?> type, EjbDescriptor<?> descriptor) {
        StringBuilder builder = BeanIdentifiers.getPrefix(SessionBean.class).append(descriptor.getEjbName());
        if (!type.isDiscovered()) {
            builder.append(SEPARATOR).append(((AnnotatedTypeIdentifier)type.slim().getIdentifier()).asString());
        }
        return builder.toString();
    }

    public static String forNewSessionBean(EjbDescriptor<?> descriptor) {
        return BeanIdentifiers.getPrefix(NewSessionBean.class).append(descriptor.getEjbName()).toString();
    }

    public static String forProducerField(EnhancedAnnotatedField<?, ?> field, AbstractClassBean<?> declaringBean) {
        StringBuilder sb = BeanIdentifiers.getPrefix(ProducerField.class).append(((AnnotatedTypeIdentifier)declaringBean.getAnnotated().getIdentifier()).asString()).append(SEPARATOR);
        if (declaringBean.getEnhancedAnnotated().isDiscovered()) {
            sb.append(field.getName());
        } else {
            sb.append(AnnotatedTypes.createFieldId(field));
        }
        return sb.toString();
    }

    public static String forProducerMethod(EnhancedAnnotatedMethod<?, ?> method, AbstractClassBean<?> declaringBean) {
        if (declaringBean.getEnhancedAnnotated().isDiscovered()) {
            return BeanIdentifiers.forProducerMethod((AnnotatedTypeIdentifier)declaringBean.getAnnotated().getIdentifier(), DeclaredMemberIndexer.getIndexForMethod((Method)method.getJavaMember()));
        }
        return BeanIdentifiers.getPrefix(ProducerMethod.class).append(method.getDeclaringType().slim().getIdentifier()).append(AnnotatedTypes.createCallableId(method)).toString();
    }

    public static String forProducerMethod(AnnotatedTypeIdentifier identifier, int memberIndex) {
        return BeanIdentifiers.getPrefix(ProducerMethod.class).append(identifier.asString()).append(SEPARATOR).append(memberIndex).toString();
    }

    public static String forSyntheticBean(BeanAttributes<?> attributes, Class<?> beanClass) {
        return BeanIdentifiers.getPrefix(AbstractSyntheticBean.class).append(beanClass.getName()).append(SEPARATOR).append(Beans.createBeanAttributesId(attributes)).toString();
    }

    public static String forBuiltInBean(BeanManagerImpl manager, Class<?> type, String suffix) {
        StringBuilder builder = BeanIdentifiers.getPrefix(AbstractSyntheticBean.class).append(manager.getId()).append(SEPARATOR).append(type.getSimpleName());
        if (suffix != null) {
            builder.append(SEPARATOR).append(suffix);
        }
        return builder.toString();
    }

    public static String forExtension(EnhancedAnnotatedType<?> type) {
        return BeanIdentifiers.getPrefix(Extension.class).append(((AnnotatedTypeIdentifier)type.slim().getIdentifier()).asString()).toString();
    }
}

