/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.interceptor;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bean.interceptor.WeldAnnotatedMethodReader;
import org.jboss.weld.interceptor.reader.DefaultMethodMetadata;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.util.collections.WeldCollections;

public class WeldInterceptorClassMetadata<T>
implements ClassMetadata<T> {
    private final SlimAnnotatedType<T> type;
    private final WeldInterceptorClassMetadata<?> superclass;
    private final Map<Method, MethodMetadata> methodMetadata;

    private WeldInterceptorClassMetadata(EnhancedAnnotatedType<T> weldClass) {
        this.type = weldClass.slim();
        HashMap<Member, MethodMetadata> methodMetadataMap = new HashMap<Member, MethodMetadata>();
        for (EnhancedAnnotatedMethod<?, T> method : weldClass.getDeclaredEnhancedMethods()) {
            MethodMetadata methodMetadata = DefaultMethodMetadata.of(method, WeldAnnotatedMethodReader.getInstance());
            if (methodMetadata.getSupportedInterceptionTypes() == null || methodMetadata.getSupportedInterceptionTypes().size() == 0) continue;
            methodMetadataMap.put(method.getJavaMember(), methodMetadata);
        }
        this.methodMetadata = WeldCollections.immutableMap(methodMetadataMap);
        this.superclass = weldClass.getEnhancedSuperclass() == null || weldClass.getEnhancedSuperclass().getJavaClass().equals(Object.class) ? null : WeldInterceptorClassMetadata.of(weldClass.getEnhancedSuperclass());
    }

    public static <T> WeldInterceptorClassMetadata<T> of(EnhancedAnnotatedType<T> weldClass) {
        return new WeldInterceptorClassMetadata<T>(weldClass);
    }

    @Override
    public String getClassName() {
        return this.getJavaClass().getName();
    }

    @Override
    public Iterable<MethodMetadata> getDeclaredMethods() {
        return this.methodMetadata.values();
    }

    @Override
    public MethodMetadata getDeclaredMethod(Method method) {
        return this.methodMetadata.get(method);
    }

    @Override
    public Class<T> getJavaClass() {
        return this.type.getJavaClass();
    }

    @Override
    public ClassMetadata<?> getSuperclass() {
        return this.superclass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WeldInterceptorClassMetadata other = (WeldInterceptorClassMetadata)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "WeldInterceptorClassMetadata [type=" + this.type + "]";
    }
}

