/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.conversation;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.inject.Inject;
import org.jboss.weld.context.AbstractConversationContext;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.ManagedConversation;
import org.jboss.weld.logging.ConversationLogger;
import org.jboss.weld.manager.BeanManagerImpl;

public class ConversationImpl
implements ManagedConversation,
Serializable {
    private static final long serialVersionUID = -5566903049468084035L;
    private String id;
    private boolean _transient;
    private long timeout;
    private final ReentrantLock concurrencyLock;
    private long lastUsed;
    private BeanManagerImpl manager;

    @Inject
    public ConversationImpl(BeanManagerImpl manager) {
        this.manager = manager;
        this._transient = true;
        this.timeout = this.isContextActive() ? this.getActiveConversationContext().getDefaultTimeout() : 0L;
        this.concurrencyLock = new ReentrantLock();
        this.touch();
    }

    @Override
    public void begin() {
        this.verifyConversationContextActive();
        if (!this._transient) {
            throw ConversationLogger.LOG.beginCalledOnLongRunningConversation();
        }
        this._transient = false;
        if (this.id == null) {
            this.id = this.getActiveConversationContext().generateConversationId();
        }
        this.notifyConversationContext();
        ConversationLogger.LOG.promotedTransient(this.id);
    }

    @Override
    public void begin(String id) {
        this.verifyConversationContextActive();
        if (!this._transient) {
            throw ConversationLogger.LOG.beginCalledOnLongRunningConversation();
        }
        if (this.getActiveConversationContext().getConversation(id) != null) {
            throw ConversationLogger.LOG.conversationIdAlreadyInUse(id);
        }
        this._transient = false;
        this.id = id;
        this.notifyConversationContext();
        ConversationLogger.LOG.promotedTransient(id);
    }

    private void notifyConversationContext() {
        ConversationContext context = this.getActiveConversationContext();
        if (context instanceof AbstractConversationContext) {
            AbstractConversationContext abstractConversationContext = (AbstractConversationContext)context;
            abstractConversationContext.conversationPromotedToLongRunning(this);
        }
    }

    @Override
    public void end() {
        this.verifyConversationContextActive();
        if (this._transient) {
            throw ConversationLogger.LOG.endCalledOnTransientConversation();
        }
        ConversationLogger.LOG.demotedLrc(this.id);
        this._transient = true;
    }

    @Override
    public String getId() {
        this.verifyConversationContextActive();
        if (!this._transient) {
            return this.id;
        }
        return null;
    }

    @Override
    public long getTimeout() {
        this.verifyConversationContextActive();
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.verifyConversationContextActive();
        this.timeout = timeout;
    }

    public String toString() {
        if (this._transient) {
            return "Transient conversation";
        }
        return "Conversation with id: " + this.id;
    }

    @Override
    public boolean isTransient() {
        this.verifyConversationContextActive();
        return this._transient;
    }

    @Override
    public long getLastUsed() {
        this.verifyConversationContextActive();
        return this.lastUsed;
    }

    @Override
    public void touch() {
        this.verifyConversationContextActive();
        this.lastUsed = System.currentTimeMillis();
    }

    @Override
    public boolean lock(long timeout) {
        boolean success;
        this.verifyConversationContextActive();
        try {
            success = this.concurrencyLock.tryLock(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            success = false;
        }
        if (success) {
            ConversationLogger.LOG.conversationLocked(this);
        } else {
            ConversationLogger.LOG.conversationUnavailable(timeout, this);
        }
        return success;
    }

    @Override
    public boolean unlock() {
        this.verifyConversationContextActive();
        if (!this.concurrencyLock.isLocked()) {
            return true;
        }
        if (this.concurrencyLock.isHeldByCurrentThread()) {
            this.concurrencyLock.unlock();
            ConversationLogger.LOG.conversationUnlocked(this);
        } else {
            ConversationLogger.LOG.illegalConversationUnlockAttempt(this, "not owner");
        }
        return !this.concurrencyLock.isLocked();
    }

    private void verifyConversationContextActive() {
        if (!this.isContextActive()) {
            throw new ContextNotActiveException("Conversation Context not active when method called on conversation " + this);
        }
    }

    public boolean isContextActive() {
        return this.manager.isContextActive(ConversationScoped.class);
    }

    private ConversationContext getActiveConversationContext() {
        return (ConversationContext)this.manager.getUnwrappedContext(ConversationScoped.class);
    }
}

