/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery.url;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.TypeDiscoveryConfiguration;
import org.jboss.weld.environment.se.discovery.WeldSEBeanDeploymentArchive;
import org.jboss.weld.environment.se.discovery.url.BeanArchiveBuilder;
import org.jboss.weld.environment.se.discovery.url.DiscoveryStrategy;
import org.jboss.weld.resources.spi.ResourceLoader;

public class JandexEnabledDiscoveryStrategy
extends DiscoveryStrategy {
    private static final int ANNOTATION = 8192;
    private final TypeDiscoveryConfiguration typeDiscoveryConfiguration;
    private Set<DotName> beanDefiningAnnotations;
    private CompositeIndex cindex;

    public JandexEnabledDiscoveryStrategy(ResourceLoader resourceLoader, Bootstrap bootstrap, TypeDiscoveryConfiguration typeDiscoveryConfiguration) {
        super(resourceLoader, bootstrap);
        this.typeDiscoveryConfiguration = typeDiscoveryConfiguration;
    }

    @Override
    protected void initialize() {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        for (BeanArchiveBuilder builder : this.getBuilders()) {
            IndexView index = (IndexView)builder.getIndex();
            indexes.add(index);
        }
        this.cindex = CompositeIndex.create(indexes);
        this.beanDefiningAnnotations = this.buildBeanDefiningAnnotationSet(this.typeDiscoveryConfiguration, this.cindex);
    }

    @Override
    protected WeldSEBeanDeploymentArchive processAnnotatedDiscovery(BeanArchiveBuilder builder) {
        Iterator<String> classIterator = builder.getClassIterator();
        while (classIterator.hasNext()) {
            String className = classIterator.next();
            ClassInfo cinfo = this.cindex.getClassByName(DotName.createSimple((String)className));
            if (this.containsBeanDefiningAnnotation(cinfo.annotations().keySet())) continue;
            classIterator.remove();
        }
        WeldSEBeanDeploymentArchive bda = builder.build();
        return bda;
    }

    private Set<DotName> buildBeanDefiningAnnotationSet(TypeDiscoveryConfiguration typeDiscoveryConfiguration, CompositeIndex index) {
        ImmutableSet.Builder beanDefiningAnnotations = ImmutableSet.builder();
        for (Class<? extends Annotation> annotation : typeDiscoveryConfiguration.getKnownBeanDefiningAnnotations()) {
            DotName annotationDotName = DotName.createSimple((String)annotation.getName());
            if (this.isMetaAnnotation(annotation)) {
                for (AnnotationInstance instance : index.getAnnotations(annotationDotName)) {
                    ClassInfo classInfo;
                    if (!(instance.target() instanceof ClassInfo) || ((classInfo = (ClassInfo)instance.target()).flags() & 0x2000) == 0) continue;
                    beanDefiningAnnotations.add(classInfo.name());
                }
                continue;
            }
            beanDefiningAnnotations.add(annotationDotName);
        }
        return beanDefiningAnnotations.build();
    }

    private boolean isMetaAnnotation(Class<? extends Annotation> annotation) {
        Target target = annotation.getAnnotation(Target.class);
        if (target == null) {
            return false;
        }
        if (target.value() == null) {
            return false;
        }
        for (ElementType elementType : target.value()) {
            if (!ElementType.ANNOTATION_TYPE.equals((Object)elementType)) continue;
            return true;
        }
        return false;
    }

    private boolean containsBeanDefiningAnnotation(Set<DotName> annotations) {
        for (DotName name : annotations) {
            if (!this.beanDefiningAnnotations.contains(name)) continue;
            return true;
        }
        return false;
    }

    public CompositeIndex getCompositeJandexIndex() {
        return this.cindex;
    }
}

