/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.contexts.interceptors;

import javax.annotation.Priority;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.weld.environment.se.WeldSEBeanRegistrant;
import org.jboss.weld.environment.se.contexts.ThreadContext;
import org.jboss.weld.environment.se.contexts.interceptors.ActivateThreadScope;

@Vetoed
@Interceptor
@ActivateThreadScope
@Priority(value=2100)
public class ActivateThreadScopeInterceptor {
    private final ThreadContext threadContext;

    @Inject
    public ActivateThreadScopeInterceptor(WeldSEBeanRegistrant registrant) {
        this.threadContext = registrant.getThreadContext();
    }

    @AroundInvoke
    Object intercept(InvocationContext invocationContext) throws Exception {
        if (!this.threadContext.isActive()) {
            try {
                this.threadContext.activate();
                Object object = invocationContext.proceed();
                return object;
            }
            finally {
                this.threadContext.invalidate();
                this.threadContext.deactivate();
            }
        }
        return invocationContext.proceed();
    }
}

