/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery.url;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemURLHandler {
    private static final Logger log = LoggerFactory.getLogger(FileSystemURLHandler.class);
    private static final String CLASS_FILE_EXTENSION = ".class";
    private static final String BEANS_XML = "beans.xml";
    private List<String> discoveredClasses = new ArrayList<String>();
    private List<URL> discoveredBeansXmlUrls = new ArrayList<URL>();

    public void handle(String urlPath) {
        try {
            log.trace("scanning: {}", (Object)urlPath);
            File file = new File(urlPath);
            if (file.isDirectory()) {
                this.handleDirectory(file, null);
            } else {
                this.handleArchiveByFile(file);
            }
        }
        catch (IOException ioe) {
            log.warn("could not read entries", (Throwable)ioe);
        }
    }

    private void handleArchiveByFile(File file) throws IOException {
        try {
            log.trace("archive: {}", (Object)file);
            String archiveUrl = "jar:" + file.toURI().toURL().toExternalForm() + "!/";
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                this.addToDiscovered(name, new URL(archiveUrl + name));
            }
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    private void handleDirectory(File dir, String path) {
        log.trace("handling directory: {}", (Object)dir);
        File[] files = dir.listFiles();
        assert (files != null);
        for (File child : files) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
                continue;
            }
            try {
                this.addToDiscovered(newPath, child.toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.error("Error loading file {}", (Object)newPath);
            }
        }
    }

    protected void addToDiscovered(String name, URL url) {
        if (name.endsWith(CLASS_FILE_EXTENSION)) {
            this.discoveredClasses.add(FileSystemURLHandler.filenameToClassname(name));
        } else if (name.endsWith(BEANS_XML)) {
            this.discoveredBeansXmlUrls.add(url);
        }
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(CLASS_FILE_EXTENSION)).replace('/', '.').replace('\\', '.');
    }

    public List<String> getDiscoveredClasses() {
        return this.discoveredClasses;
    }

    public List<URL> getDiscoveredBeansXmlUrls() {
        return this.discoveredBeansXmlUrls;
    }
}

