/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery.url;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.environment.se.discovery.ImmutableBeanDeploymentArchive;
import org.jboss.weld.environment.se.discovery.url.FileSystemURLHandler;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLScanner {
    private static final Logger log = LoggerFactory.getLogger(URLScanner.class);
    private static final String FILE = "file";
    private static final String SEPARATOR = "!/";
    private final String[] resources;
    private final ResourceLoader resourceLoader;
    private final Bootstrap bootstrap;

    public URLScanner(ResourceLoader resourceLoader, Bootstrap bootstrap, String ... resources) {
        this.resources = resources;
        this.resourceLoader = resourceLoader;
        this.bootstrap = bootstrap;
    }

    public BeanDeploymentArchive scan() {
        FileSystemURLHandler handler = new FileSystemURLHandler();
        for (String resourceName : this.resources) {
            for (URL url : this.resourceLoader.getResources(resourceName)) {
                try {
                    handler.handle(this.getUrlPath(resourceName, url));
                }
                catch (URISyntaxException e) {
                    log.warn("could not read: " + resourceName, (Throwable)e);
                }
            }
        }
        return new ImmutableBeanDeploymentArchive("classpath", handler.getDiscoveredClasses(), this.bootstrap.parse(handler.getDiscoveredBeansXmlUrls(), true));
    }

    private String getUrlPath(String resourceName, URL url) throws URISyntaxException {
        String urlPath = url.toExternalForm();
        String urlType = this.getUrlType(urlPath);
        log.debug("URL Type: {}", (Object)urlType);
        boolean isFile = FILE.equals(urlType);
        boolean isJar = "jar".equals(urlType);
        if (isFile || isJar) {
            urlPath = url.toURI().getSchemeSpecificPart();
            if (isJar && urlPath.lastIndexOf(SEPARATOR) > 0) {
                urlPath = urlPath.substring(0, urlPath.lastIndexOf(SEPARATOR));
                String fileUrlType = "file:";
                if (urlPath.startsWith("file:")) {
                    urlPath = urlPath.substring("file:".length());
                }
            } else {
                File dirOrArchive = new File(urlPath);
                if (resourceName != null && resourceName.lastIndexOf(47) > 0) {
                    dirOrArchive = dirOrArchive.getParentFile();
                }
                urlPath = dirOrArchive.getParent();
            }
        }
        return urlPath;
    }

    private String getUrlType(String urlPath) {
        String urlType = FILE;
        int colonIndex = urlPath.indexOf(":");
        if (colonIndex != -1) {
            urlType = urlPath.substring(0, colonIndex);
        }
        return urlType;
    }
}

