/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.weld.AbstractCDI;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.environment.ContainerInstance;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.jboss.weld.environment.se.events.ContainerShutdown;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldManager;

@Vetoed
public class WeldContainer
extends AbstractCDI<Object>
implements AutoCloseable,
ContainerInstance {
    private static final Singleton<WeldContainer> SINGLETON;
    private static final List<String> RUNNING_CONTAINER_IDS;
    private static final Object LOCK;
    private static volatile ShutdownHook shutdownHook;
    private final String id;
    private final WeldManager manager;
    private final Bootstrap bootstrap;
    private final Instance<Object> instance;
    private final Event<Object> event;
    private final CreationalContext<?> creationalContext;

    public static WeldContainer instance(String id) {
        try {
            return (WeldContainer)SINGLETON.get(id);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static List<String> getRunningContainerIds() {
        return ImmutableList.copyOf(RUNNING_CONTAINER_IDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WeldContainer initialize(String id, WeldManager manager, Bootstrap bootstrap, boolean isShutdownHookEnabled) {
        if (SINGLETON.isSet(id)) {
            throw WeldSELogger.LOG.weldContainerAlreadyRunning(id);
        }
        WeldContainer weldContainer = new WeldContainer(id, manager, bootstrap);
        SINGLETON.set(id, (Object)weldContainer);
        RUNNING_CONTAINER_IDS.add(id);
        WeldSELogger.LOG.weldContainerInitialized(id);
        manager.fireEvent((Object)new ContainerInitialized(id), new Annotation[]{InitializedLiteral.APPLICATION});
        if (shutdownHook == null && isShutdownHookEnabled) {
            Object object = LOCK;
            synchronized (object) {
                if (shutdownHook == null) {
                    shutdownHook = new ShutdownHook();
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                }
            }
        }
        return weldContainer;
    }

    private WeldContainer(String id, WeldManager manager, Bootstrap bootstrap) {
        this.id = id;
        this.manager = manager;
        this.bootstrap = bootstrap;
        this.creationalContext = manager.createCreationalContext(null);
        BeanManagerImpl beanManagerImpl = (BeanManagerImpl)manager.unwrap();
        this.instance = beanManagerImpl.getInstance(this.creationalContext);
        this.event = beanManagerImpl.event();
    }

    public Instance<Object> instance() {
        return this.instance;
    }

    public Event<Object> event() {
        return this.event;
    }

    public String getId() {
        return this.id;
    }

    public BeanManager getBeanManager() {
        return this.manager;
    }

    public synchronized void shutdown() {
        if (this.isRunning()) {
            try {
                this.manager.fireEvent((Object)new ContainerShutdown(this.id), new Annotation[]{DestroyedLiteral.APPLICATION});
            }
            finally {
                SINGLETON.clear(this.id);
                RUNNING_CONTAINER_IDS.remove(this.id);
                this.creationalContext.release();
                this.bootstrap.shutdown();
                WeldSELogger.LOG.weldContainerShutdown(this.id);
            }
        } else {
            if (WeldSELogger.LOG.isTraceEnabled()) {
                WeldSELogger.LOG.tracev("Spurious call to shutdown from: {0}", Thread.currentThread().getStackTrace());
            }
            throw WeldSELogger.LOG.weldContainerAlreadyShutDown(this.id);
        }
    }

    public boolean isRunning() {
        return SINGLETON.isSet(this.id);
    }

    @Override
    public void close() {
        this.shutdown();
    }

    protected Instance<Object> getInstance() {
        return this.instance;
    }

    static {
        LOCK = new Object();
        SINGLETON = SingletonProvider.instance().create(WeldContainer.class);
        RUNNING_CONTAINER_IDS = new CopyOnWriteArrayList<String>();
    }

    static class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            for (String id : WeldContainer.getRunningContainerIds()) {
                WeldContainer container = WeldContainer.instance(id);
                if (container == null) continue;
                container.shutdown();
                System.out.println(String.format("Weld SE container %s shut down by shutdown hook", id));
            }
        }
    }
}

