/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Singleton;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.events.AbstractContainerEvent;
import org.jboss.weld.bootstrap.events.InterceptorBuilderImpl;
import org.jboss.weld.bootstrap.events.builder.BeanBuilderImpl;
import org.jboss.weld.bootstrap.events.builder.BeanConfiguratorImpl;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.beans.ParametersFactory;
import org.jboss.weld.environment.se.contexts.ThreadContext;
import org.jboss.weld.environment.se.contexts.activators.ActivateThreadScopeInterceptor;
import org.jboss.weld.environment.se.threading.RunnableDecorator;
import org.jboss.weld.experimental.ExperimentalAfterBeanDiscovery;
import org.jboss.weld.experimental.InterceptorBuilder;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.util.annotated.VetoedSuppressedAnnotatedType;

@Vetoed
public class WeldSEBeanRegistrant
implements Extension {
    private ThreadContext threadContext;
    private List<BeanConfiguratorImpl<?>> beanConfigurators;
    private List<InterceptorBuilderImpl> interceptorBuilders;

    public void registerWeldSEBeans(@Observes BeforeBeanDiscovery event, BeanManager manager) {
        if (WeldSEBeanRegistrant.ignoreEvent(event)) {
            return;
        }
        event.addAnnotatedType((AnnotatedType)VetoedSuppressedAnnotatedType.from(ParametersFactory.class, (BeanManager)manager), ParametersFactory.class.getName());
        event.addAnnotatedType((AnnotatedType)VetoedSuppressedAnnotatedType.from(RunnableDecorator.class, (BeanManager)manager), RunnableDecorator.class.getName());
        event.addAnnotatedType((AnnotatedType)VetoedSuppressedAnnotatedType.from(ActivateThreadScopeInterceptor.class, (BeanManager)manager), ActivateThreadScopeInterceptor.class.getName());
    }

    public void registerWeldSEContexts(@Observes ExperimentalAfterBeanDiscovery event, BeanManager manager) {
        if (WeldSEBeanRegistrant.ignoreEvent(event)) {
            return;
        }
        String contextId = BeanManagerProxy.unwrap((BeanManager)manager).getContextId();
        this.threadContext = new ThreadContext(contextId);
        event.addContext((Context)this.threadContext);
        event.addBean().addType(WeldContainer.class).addQualifier((Annotation)DefaultLiteral.INSTANCE).scope(Singleton.class).produceWith(() -> WeldContainer.instance(contextId));
        if (this.beanConfigurators != null) {
            for (BeanConfiguratorImpl<?> beanConfiguratorImpl : this.beanConfigurators) {
                event.addBean(new BeanBuilderImpl(beanConfiguratorImpl).build());
            }
        }
        if (this.interceptorBuilders != null) {
            for (InterceptorBuilder interceptorBuilder : this.interceptorBuilders) {
                event.addBean((Bean)interceptorBuilder.build());
            }
        }
    }

    private static boolean ignoreEvent(Object event) {
        return !(event instanceof AbstractContainerEvent);
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    void setBeanConfigurators(List<BeanConfiguratorImpl<?>> beanConfigurators) {
        this.beanConfigurators = beanConfigurators;
    }

    void setInterceptorBuilders(List<InterceptorBuilderImpl> interceptorBuilders) {
        this.interceptorBuilders = interceptorBuilders;
    }
}

