/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Shutdown;
import jakarta.enterprise.event.Startup;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.weld.AbstractCDI;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.environment.ContainerInstance;
import org.jboss.weld.environment.deployment.WeldDeployment;
import org.jboss.weld.environment.se.events.ContainerBeforeShutdown;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.jboss.weld.environment.se.events.ContainerShutdown;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.events.WeldEvent;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.ImmutableList;

@Vetoed
public class WeldContainer
extends AbstractCDI<Object>
implements AutoCloseable,
ContainerInstance,
SeContainer {
    private static final Singleton<WeldContainer> SINGLETON;
    private static final List<String> RUNNING_CONTAINER_IDS;
    private static final Object LOCK;
    private static volatile ShutdownHook shutdownHook;
    private final String id;
    private final Deployment deployment;
    private final Bootstrap bootstrap;
    private volatile WeldInstance<Object> instance;
    private volatile WeldEvent<Object> event;
    private volatile CreationalContext<?> creationalContext;
    private volatile BeanManagerImpl beanManager;

    public static WeldContainer instance(String id) {
        try {
            return (WeldContainer)SINGLETON.get(id);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static WeldContainer current() {
        List<String> ids = WeldContainer.getRunningContainerIds();
        if (ids.size() == 1) {
            return WeldContainer.instance(ids.get(0));
        }
        throw WeldSELogger.LOG.zeroOrMoreThanOneContainerRunning();
    }

    public static List<String> getRunningContainerIds() {
        return ImmutableList.copyOf(RUNNING_CONTAINER_IDS);
    }

    static WeldContainer startInitialization(String id, Deployment deployment, Bootstrap bootstrap) {
        if (SINGLETON.isSet(id)) {
            throw WeldSELogger.LOG.weldContainerAlreadyRunning(id);
        }
        WeldContainer weldContainer = new WeldContainer(id, deployment, bootstrap);
        SINGLETON.set(id, (Object)weldContainer);
        RUNNING_CONTAINER_IDS.add(id);
        return weldContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void endInitialization(WeldContainer container, boolean isShutdownHookEnabled) {
        container.complete();
        if (shutdownHook == null && isShutdownHookEnabled) {
            Object object = LOCK;
            synchronized (object) {
                if (shutdownHook == null) {
                    shutdownHook = new ShutdownHook();
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                }
            }
        }
        container.fireContainerInitializedEvent();
    }

    static void discard(String containerId) {
        SINGLETON.clear(containerId);
        RUNNING_CONTAINER_IDS.remove(containerId);
    }

    private WeldContainer(String id, Deployment deployment, Bootstrap bootstrap) {
        this.id = id;
        this.deployment = deployment;
        this.bootstrap = bootstrap;
    }

    private void complete() {
        this.getInstance();
        this.event();
    }

    private void fireContainerInitializedEvent() {
        WeldSELogger.LOG.weldContainerInitialized(this.id);
        this.beanManager().getEvent().select(ContainerInitialized.class, new Annotation[]{Initialized.Literal.APPLICATION}).fire((Object)new ContainerInitialized(this.id));
        Environment env = Container.getEnvironment();
        if (env != null && env.automaticallyHandleStartupShutdownEvents()) {
            this.beanManager().getEvent().select(Startup.class, new Annotation[]{Any.Literal.INSTANCE}).fire((Object)new Startup());
        }
    }

    public Instance<Object> instance() {
        this.checkState();
        return this.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WeldEvent<Object> event() {
        this.checkIsRunning();
        if (this.event == null) {
            WeldContainer weldContainer = this;
            synchronized (weldContainer) {
                if (this.event == null) {
                    this.event = this.beanManager().event();
                }
            }
        }
        return this.event;
    }

    public String getId() {
        return this.id;
    }

    public BeanManager getBeanManager() {
        this.checkIsRunning();
        return new BeanManagerProxy(this.beanManager());
    }

    public synchronized void shutdown() {
        this.checkIsRunning();
        try {
            Environment env = Container.getEnvironment();
            if (env != null && env.automaticallyHandleStartupShutdownEvents()) {
                this.beanManager().getEvent().select(Shutdown.class, new Annotation[]{Any.Literal.INSTANCE}).fire((Object)new Shutdown());
            }
            this.beanManager().getEvent().select(ContainerBeforeShutdown.class, new Annotation[]{BeforeDestroyed.Literal.APPLICATION}).fire((Object)new ContainerBeforeShutdown(this.id));
        }
        catch (Throwable throwable) {
            WeldContainer.discard(this.id);
            this.creationalContext.release();
            this.beanManager().getEvent().select(ContainerShutdown.class, new Annotation[]{Destroyed.Literal.APPLICATION}).fire((Object)new ContainerShutdown(this.id));
            this.bootstrap.shutdown();
            WeldSELogger.LOG.weldContainerShutdown(this.id);
            throw throwable;
        }
        WeldContainer.discard(this.id);
        this.creationalContext.release();
        this.beanManager().getEvent().select(ContainerShutdown.class, new Annotation[]{Destroyed.Literal.APPLICATION}).fire((Object)new ContainerShutdown(this.id));
        this.bootstrap.shutdown();
        WeldSELogger.LOG.weldContainerShutdown(this.id);
    }

    public boolean isRunning() {
        return SINGLETON.isSet(this.id) && this.instance != null;
    }

    @Override
    public void close() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WeldInstance<Object> getInstance() {
        if (this.instance == null) {
            WeldContainer weldContainer = this;
            synchronized (weldContainer) {
                if (this.instance == null) {
                    this.creationalContext = this.beanManager().createCreationalContext(null);
                    this.instance = this.beanManager().getInstance(this.creationalContext);
                }
            }
        }
        return this.instance;
    }

    protected void checkState() {
        this.checkDeploymentValidated();
        this.checkIsRunning();
    }

    private void checkDeploymentValidated() {
        ContainerState state = Container.instance((String)this.id).getState();
        if (state.compareTo((Enum)ContainerState.VALIDATED) < 0) {
            throw WeldSELogger.LOG.weldContainerDeploymentNotValidated(this.id);
        }
    }

    private void checkIsRunning() {
        if (!SINGLETON.isSet(this.id)) {
            if (WeldSELogger.LOG.isTraceEnabled()) {
                WeldSELogger.LOG.tracev("Spurious call to shutdown from: {0}", Thread.currentThread().getStackTrace());
            }
            throw WeldSELogger.LOG.weldContainerAlreadyShutDown(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanManagerImpl beanManager() {
        if (this.beanManager == null) {
            WeldContainer weldContainer = this;
            synchronized (weldContainer) {
                if (this.beanManager == null) {
                    this.beanManager = BeanManagerProxy.unwrap((BeanManager)this.bootstrap.getManager(this.getDeterminingBeanDeploymentArchive(this.deployment)));
                }
            }
        }
        return this.beanManager;
    }

    private BeanDeploymentArchive getDeterminingBeanDeploymentArchive(Deployment deployment) {
        Collection beanDeploymentArchives = deployment.getBeanDeploymentArchives();
        if (beanDeploymentArchives.size() == 1) {
            return (BeanDeploymentArchive)beanDeploymentArchives.iterator().next();
        }
        for (BeanDeploymentArchive beanDeploymentArchive : beanDeploymentArchives) {
            if (!WeldDeployment.SYNTHETIC_BDA_ID.equals(beanDeploymentArchive.getId())) continue;
            return beanDeploymentArchive;
        }
        for (BeanDeploymentArchive beanDeploymentArchive : beanDeploymentArchives) {
            if (WeldDeployment.ADDITIONAL_BDA_ID.equals(beanDeploymentArchive.getId())) continue;
            return beanDeploymentArchive;
        }
        return deployment.loadBeanDeploymentArchive(WeldContainer.class);
    }

    static {
        LOCK = new Object();
        SINGLETON = SingletonProvider.instance().create(WeldContainer.class);
        RUNNING_CONTAINER_IDS = new CopyOnWriteArrayList<String>();
    }

    static class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            for (String id : WeldContainer.getRunningContainerIds()) {
                WeldContainer container = WeldContainer.instance(id);
                if (container == null) continue;
                container.shutdown();
                System.out.println(String.format("Weld SE container %s shut down by shutdown hook", id));
            }
        }
    }
}

